package net.aihelp.core.ui.glide.load.model.stream;

import android.content.Context;

import net.aihelp.core.ui.glide.load.model.GenericLoaderFactory;
import net.aihelp.core.ui.glide.load.model.GlideUrl;
import net.aihelp.core.ui.glide.load.model.ModelLoader;
import net.aihelp.core.ui.glide.load.model.ModelLoaderFactory;
import net.aihelp.core.ui.glide.load.model.UrlLoader;

import java.io.InputStream;
import java.net.URL;

/**
 * A wrapper class that translates {@link URL} objects into {@link GlideUrl}
 * objects and then uses the wrapped {@link ModelLoader} for
 * {@link GlideUrl}s to load the {@link InputStream} data.
 */
public class StreamUrlLoader extends UrlLoader<InputStream> {

    /**
     * The default factory for {@link net.aihelp.core.ui.glide.load.model.stream.StreamUrlLoader}s.
     */
    public static class Factory implements ModelLoaderFactory<URL, InputStream> {
        @Override
        public ModelLoader<URL, InputStream> build(Context context, GenericLoaderFactory factories) {
            return new StreamUrlLoader(factories.buildModelLoader(GlideUrl.class, InputStream.class));
        }

        @Override
        public void teardown() {
            // Do nothing.
        }
    }

    public StreamUrlLoader(ModelLoader<GlideUrl, InputStream> glideUrlLoader) {
        super(glideUrlLoader);
    }
}
