package net.aihelp.core.ui.glide.load.resource.transcode;

import net.aihelp.core.ui.glide.load.engine.Resource;
import net.aihelp.core.ui.glide.load.resource.bytes.BytesResource;
import net.aihelp.core.ui.glide.load.resource.gif.GifDrawable;

/**
 * An {@link net.aihelp.core.ui.glide.load.resource.transcode.ResourceTranscoder} that converts
 * {@link net.aihelp.core.ui.glide.load.resource.gif.GifDrawable} into bytes by obtaining the original bytes of the GIF from
 * the {@link net.aihelp.core.ui.glide.load.resource.gif.GifDrawable}.
 */
public class GifDrawableBytesTranscoder implements ResourceTranscoder<GifDrawable, byte[]> {
    @Override
    public Resource<byte[]> transcode(Resource<GifDrawable> toTranscode) {
        GifDrawable gifData = toTranscode.get();
        return new BytesResource(gifData.getData());
    }

    @Override
    public String getId() {
        return "GifDrawableBytesTranscoder.net.aihelp.core.ui.glide.load.resource.transcode";
    }
}
