package net.aihelp.core.ui.loading.helper;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;

import net.aihelp.utils.ResResolver;

import androidx.core.content.ContextCompat;

public class VaryViewHelperController {

    private Context mContext;
    private final VaryViewHelper helper;

    public VaryViewHelperController(View view) {
        this(new VaryViewHelper(view));
        mContext = view.getContext();
    }

    private VaryViewHelperController(VaryViewHelper helper) {
        this.helper = helper;
    }

    public void showLoading(String msg) {
        View layout = helper.inflate(ResResolver.getLayoutId("aihelp_layout_progress_loading"));
        ProgressBar progressBar = layout.findViewById(ResResolver.getViewId("aihelp_loading_progress"));
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {
            Drawable drawable = progressBar.getIndeterminateDrawable().mutate();
            drawable.setColorFilter(ContextCompat.getColor(mContext, ResResolver.getColorId("aihelp_color_main")), PorterDuff.Mode.SRC_IN);
            progressBar.setIndeterminateDrawable(drawable);
        }

        TextView textView = layout.findViewById(ResResolver.getViewId("aihelp_loading_msg"));
        textView.setText(!TextUtils.isEmpty(msg) ? msg : ResResolver.getString("aihelp_faq_fetching_faqs"));

        helper.showLayout(layout);
    }

    public void showEmpty(int... layoutId) {
        if (layoutId != null && layoutId.length > 0) {
            View layout = helper.inflate(layoutId[0]);
            helper.showLayout(layout);
        }
    }

    public void showEmpty(View view) {
        if (view != null) {
            helper.showLayout(view);
        }
    }

    public void showNetworkError() {
        View layout = helper.inflate(ResResolver.getLayoutId("aihelp_layout_network_err"));
        TextView tvTitle = layout.findViewById(ResResolver.getViewId("aihelp_tv_title"));
        tvTitle.setText(ResResolver.getString("aihelp_network_error_msg"));
        TextView tvSubTitle = layout.findViewById(ResResolver.getViewId("aihelp_tv_sub_title"));
        tvSubTitle.setText(ResResolver.getString("aihelp_network_no_connect"));
        helper.showLayout(layout);
    }

    public void restore() {
        helper.restoreView();
    }

    public boolean isViewRestored() {
        return helper.isViewRestored();
    }

}
