package net.aihelp.core.util.concurrent;

public class NotifyingRunnable implements Runnable {

    private static final String TAG = "NotifyingRunnable";

    private final Runnable runnable;
    private final Object syncLock = new Object();
    private boolean isFinished;

    NotifyingRunnable(Runnable r) {
        this.runnable = r;
    }

    public void waitForCompletion() {
        synchronized(this.syncLock) {
            try {
                if (!this.isFinished) {
                    this.syncLock.wait();
                }
            } catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
    }

    public void run() {
        synchronized(this.syncLock) {
            try {
                this.runnable.run();
            } finally {
                this.isFinished = true;
                this.syncLock.notifyAll();
            }
        }
    }
}
