package net.aihelp.data.attachment;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.provider.OpenableColumns;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;


import net.aihelp.common.CustomConfig;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.UUID;

public class AttachmentHelper {

    public static Intent getIntentForMedia(int attachmentType) {
        Intent mediaIntent;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            mediaIntent = new Intent(Intent.ACTION_OPEN_DOCUMENT);
        } else {
            mediaIntent = new Intent(Intent.ACTION_GET_CONTENT);
        }
        mediaIntent.addCategory(Intent.CATEGORY_OPENABLE);
        mediaIntent.putExtra(Intent.EXTRA_LOCAL_ONLY, true);
        mediaIntent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
        return setupMimeTypeForIntent(mediaIntent, attachmentType);
    }

    public static Intent setupMimeTypeForIntent(Intent intent, int attachmentType) {
        String targetTypes = "";
        switch (attachmentType) {
            case AttachmentPicker.ATTACHMENT_TYPE_MEDIA:
                String mediaTypes = String.format("%s,%s", CustomConfig.UploadLimit.imageTypes,
                        CustomConfig.UploadLimit.videoTypes);
                targetTypes = getMIMEType(mediaTypes).trim();
                break;
            case AttachmentPicker.ATTACHMENT_TYPE_FILE:
                targetTypes = getMIMEType(CustomConfig.UploadLimit.fileTypes).trim();
                break;
            case AttachmentPicker.ATTACHMENT_TYPE_RPA:
                targetTypes = getMIMEType(CustomConfig.UploadLimit.rpaAttachmentTypes).trim();
                break;
        }
        if (!TextUtils.isEmpty(targetTypes)) {
            intent.setType(targetTypes);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                intent.putExtra(Intent.EXTRA_MIME_TYPES, targetTypes.split(" "));
            }
        }
        return intent;
    }

    public static String getMIMEType(String extension) {
        if (!TextUtils.isEmpty(extension)) {
            StringBuilder mimeTypeBuilder = new StringBuilder();
            String[] fileExtensions = extension.split(",");
            if (fileExtensions.length > 0) {
                for (String fileExtension : fileExtensions) {
                    if (!TextUtils.isEmpty(fileExtension)) {
                        String mimeTypeFromExtension = MimeTypeMap.getSingleton().getMimeTypeFromExtension(fileExtension);
                        if (!TextUtils.isEmpty(mimeTypeFromExtension)) {
                            mimeTypeBuilder.append(mimeTypeFromExtension).append(" ");
                        }
                    }
                }
                // return the builder with the trailing blank to make combining image and video types easier
                return mimeTypeBuilder.toString();
            }
        }
        return "image/jpeg image/png";
    }

    public static File getCopiedUriFile(Context context, Uri uri) {
        try {
            context.grantUriPermission(context.getPackageName(), uri, Intent.FLAG_GRANT_READ_URI_PERMISSION);
            String displayName = UUID.randomUUID().toString();
            Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                int columnIndex = cursor.getColumnIndex(OpenableColumns.DISPLAY_NAME);
                if (columnIndex > 0) {
                    displayName = cursor.getString(columnIndex);
                }
            }
            File file = new File(context.getCacheDir(), displayName);
            if (file.exists()) return file;

            InputStream inputStream = context.getContentResolver().openInputStream(uri);
            FileOutputStream outputStream = new FileOutputStream(file);
            int read;
            final byte[] buffers = new byte[8192];
            while ((read = inputStream.read(buffers)) != -1) {
                outputStream.write(buffers, 0, read);
            }
            if (cursor != null) cursor.close();
            inputStream.close();
            outputStream.close();
            return file;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

}
