package net.aihelp.data.local;

import android.content.Context;
import android.text.TextUtils;

import net.aihelp.core.mvp.AbsRepository;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.data.FaqHelper;
import net.aihelp.data.model.faq.FaqListEntity;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ElvaRepository extends AbsRepository {

    public ElvaRepository(Context context) {
        super(context);
    }

    public List<FaqListEntity> getMatchedFaqListForAlert(String query) {
        List<FaqListEntity> matchedList = new ArrayList<>();

        // 以 faqId 做 key 值，存储某个 faq 关键词、标题或相似问法的命中次数
        // 在循环完成后，会按照命中次数进行排序，从而决定最终的显示顺序
        Map<String, Integer> faqKeywordsMatching = new HashMap<>();

        // 在循环过程中根据 mainId 实时记录 title，避免最后再循环整个数组取值
        Map<String, String> faqTitleMapping = new HashMap<>();

        JSONArray sourceFaqs = FaqHelper.INSTANCE.getRawFlatFaqArray();

        outer:
        for (int i = 0; i < sourceFaqs.length(); i++) {
            JSONObject faq = JsonHelper.getJsonObject(sourceFaqs, i);
            String keywords = faq.optString("keyWords");
            String faqMainId = faq.optString("kmMainid");
            String faqTitle = faq.optString("question");
            String similarQuestions = faq.optString("similarQuestions");

            if (!TextUtils.isEmpty(keywords)) {
                String[] keywordsArr = keywords.split(",");
                // 计算当前输入内容包含某个 FAQ 关键词的数量，数量统计从 1 开始，每命中一个关键词数量就加 1
                for (String keyword : keywordsArr) {
                    if (query.toLowerCase().contains(keyword)) {
                        if (faqKeywordsMatching.size() >= 3) {
                            break outer;
                        }
                        Integer matchedCounts = faqKeywordsMatching.get(faqMainId);
                        faqKeywordsMatching.put(faqMainId, matchedCounts == null ? 1 : (matchedCounts + 1));
                        faqTitleMapping.put(faqMainId, faqTitle);
                    }
                }
                if (faqKeywordsMatching.get(faqMainId) != null) {
                    // 如果当前这条 FAQ 命中了关键词，就不需要再继续判断标题或者相似问法了
                    continue;
                }
            }

            // 如果当前 FAQ 没有命中任何关键词，就尝试判断标题
            // 标题的命中次数存入 0，以便在排序时保证命中标题的 FAQ 优先级低于命中关键词的 FAQ
            if (faqTitle.toLowerCase().contains(query.toLowerCase())) {
                faqKeywordsMatching.put(faqMainId, 0);
                faqTitleMapping.put(faqMainId, faqTitle);
                if (faqKeywordsMatching.size() >= 3) {
                    break;
                }
            }

            // 如果当前 FAQ 没有命中任何关键词以及标题，就尝试判断相似问法
            // 相似问法的命中次数存入 -1，以便在排序时保证命中相似问题的 FAQ 优先级最低
            if (similarQuestions.toLowerCase().contains(query.toLowerCase())) {
                faqKeywordsMatching.put(faqMainId, -1);
                faqTitleMapping.put(faqMainId, faqTitle);
                if (faqKeywordsMatching.size() >= 3) {
                    break;
                }
            }
        }

        List<Map.Entry<String, Integer>> list = new ArrayList<>(faqKeywordsMatching.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Integer>>() {
            public int compare(Map.Entry<String, Integer> o1,
                               Map.Entry<String, Integer> o2) {
                return -o1.getValue().compareTo(o2.getValue());
            }
        });

        for (Map.Entry<String, Integer> mapping : list) {
            String mainId = mapping.getKey();
            FaqListEntity matched = new FaqListEntity(0, mainId, faqTitleMapping.get(mainId), query);
            matchedList.add(matched);
        }

        return matchedList;
    }

}
