package net.aihelp.data.local;

import android.content.Context;
import android.text.TextUtils;

import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.SpKeys;
import net.aihelp.common.UserProfile;
import net.aihelp.config.UserConfig;
import net.aihelp.core.mvp.AbsRepository;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.LocaleUtil;


public class InitRepository extends AbsRepository {

    public InitRepository(Context context) {
        super(context);
    }

    public void saveInitConfig(String appKey, String domain, String appId, String initLanguage) {
        Const.APP_KEY = appKey;
        API.HOST_URL = DomainSupportHelper.getOptimizedDomain(domain);
        Const.APP_ID = appId;

        if (!TextUtils.isEmpty(initLanguage)) {
            Const.ORIGINAL_LANGUAGE = LocaleUtil.getFormatLanguage(initLanguage);
        }
        Const.CORRECT_LANGUAGE = Const.ORIGINAL_LANGUAGE;

        // Initialize default user info values at the first place
        // in case of the caller do not call updateUserInfo at all
        UserProfile.resetUserProfile(mContext);

    }

    public void saveUserProfileConfig(UserConfig config) {
        if (Const.TOGGLE_DISTINGUISH_USER_BY_DEVICE) {
            UserProfile.USER_ID = String.format("%s|%s",  DeviceUuidFactory.id(mContext), config.getUserId());
        } else {
            UserProfile.USER_ID = config.getUserId();
        }
        UserProfile.USER_NAME = config.getUserName();
        UserProfile.SERVER_ID = config.getServerId();
        UserProfile.CUSTOM_DATA = config.getFormatCustomData();
    }

    public void setUploadLogPath(String logPath) {
        Const.LOG_UPLOAD_PATH = logPath;
    }

    public void setNetworkCheckHostAddress(String hostAddress) {
        Const.NET_CHECK_HOST = hostAddress;
    }

    public void saveCrmInfo(String userId, String userTags) {
        doSave(SpKeys.CRM_USER_INFO + userId, String.format("%s|%s", userId, userTags));
    }

    public void saveMqttPushInfo(String pushToken, int pushPlatform) {
        Const.PUSH_INFO = String.format("%s|%s", pushToken, pushPlatform);
    }

}
