package net.aihelp.data.localize.config;

import android.text.TextUtils;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.LocalizeHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.utils.FileUtil;

import org.json.JSONArray;
import org.json.JSONObject;

public enum CommonTextHelper {

    INSTANCE;

    private static final int TYPE_HELP_CENTER = 1;
    private static final int TYPE_CUSTOMER_SERVICE = 2;
    private static final int TYPE_COMMON_SETTINGS = 3;

    private static final int TEXT_FAQ_NAVIGATION_TITLE = 1;
    private static final int TEXT_FAQ_SEARCH_HINT = 2;
    private static final int TEXT_FAQ_HOT_TOPIC_TITLE = 3;
    private static final int TEXT_FAQ_SECTION_TITLE = 4;

    private static final int TEXT_CS_NAVIGATION_TITLE = 1;
    private static final int TEXT_CS_WELCOME_MESSAGE = 2;
    private static final int TEXT_CS_INPUT_HINT = 3;
    private static final int TEXT_CS_INVITE_EVALUATE = 4;

    private static final int TEXT_COMMON_POSITIVE_HINT = 1;
    private static final int TEXT_COMMON_NEGATIVE_HINT = 2;

    public void reset() {
        CustomConfig.HelpCenter.faqNavigationTitle = "Help Center";
        CustomConfig.HelpCenter.faqSearchHint = "Please describe your problem";
        CustomConfig.HelpCenter.faqHotTopicsTitle = "Top Questions";
        CustomConfig.HelpCenter.faqSectionTitle = "FAQs";
        CustomConfig.HelpCenter.faqCSEntranceText = "Contact Us";
        CustomConfig.CustomerService.csNavigationTitle = "Customer Service";
        CustomConfig.CustomerService.csWelcomeMessage = "How can we help you?";
        CustomConfig.CustomerService.csInputHint = "Please enter content";
        CustomConfig.InitSetting.csInviteEvaluate = "Please rate our service";
        CustomConfig.InitSetting.commonPositiveFeedbackHint = "Thanks for your feedback!";
        CustomConfig.InitSetting.commonNegativeFeedbackHint = "Thanks for your feedback!";
    }

    public void prepareDataSource(int mode) {
        try {
            // 从本地读取样式配置文件
            String str = FileUtil.getContentFromFile(LocalizeUtil.getFileLocation(mode));
            if (!TextUtils.isEmpty(str)) {
                JSONArray jsonArray = new JSONArray(str);
                for (int i = 0; i < jsonArray.length(); i++) {
                    JSONObject jsonObject = JsonHelper.getJsonObject(jsonArray, i);
                    int textType = jsonObject.optInt("textType");
                    int contentType = jsonObject.optInt("contentType");
                    String content = jsonObject.optString("content");

                    if (TextUtils.isEmpty(content)) continue;

                    if (textType == TYPE_HELP_CENTER) {
                        switch (contentType) {
                            case TEXT_FAQ_NAVIGATION_TITLE:
                                CustomConfig.HelpCenter.faqNavigationTitle = content;
                                break;
                            case TEXT_FAQ_SEARCH_HINT:
                                CustomConfig.HelpCenter.faqSearchHint = content;
                                break;
                            case TEXT_FAQ_HOT_TOPIC_TITLE:
                                CustomConfig.HelpCenter.faqHotTopicsTitle = content;
                                break;
                            case TEXT_FAQ_SECTION_TITLE:
                                CustomConfig.HelpCenter.faqSectionTitle = content;
                                break;
                        }
                    } else if (textType == TYPE_CUSTOMER_SERVICE) {
                        switch (contentType) {
                            case TEXT_CS_NAVIGATION_TITLE:
                                CustomConfig.CustomerService.csNavigationTitle = content;
                                break;
                            case TEXT_CS_WELCOME_MESSAGE:
                                CustomConfig.CustomerService.csWelcomeMessage = content;
                                break;
                            case TEXT_CS_INPUT_HINT:
                                CustomConfig.CustomerService.csInputHint = content;
                                break;
                            case TEXT_CS_INVITE_EVALUATE:
                                CustomConfig.InitSetting.csInviteEvaluate = content;
                                break;
                        }
                    } else if (textType == TYPE_COMMON_SETTINGS) {
                        switch (contentType) {
                            case TEXT_COMMON_POSITIVE_HINT:
                                CustomConfig.InitSetting.commonPositiveFeedbackHint = content;
                                break;
                            case TEXT_COMMON_NEGATIVE_HINT:
                                CustomConfig.InitSetting.commonNegativeFeedbackHint = content;
                                break;
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
