package net.aihelp.data.localize.config;

import android.util.SparseArray;
import net.aihelp.core.net.json.JsonHelper;
import org.json.JSONArray;
import org.json.JSONObject;

public enum FeedbackOpinionHelper {

    INSTANCE;

    private SparseArray<JSONArray> opinionArray = new SparseArray<>();

    public SparseArray<JSONArray> getOpinionArray() {
        return opinionArray;
    }

    public void prepareDataSource(JSONArray jsonArray) {
        try {
            if (jsonArray != null) {
                for (int i = 0; i < jsonArray.length(); i++) {
                    JSONObject jsonObject = JsonHelper.getJsonObject(jsonArray, i);
                    // 回传一个 List<Map<String, String>>，其实就是一个 JsonArray
                    opinionArray.put((i + 1), JsonHelper.getJsonArray(jsonObject, "satisfyList"));
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
