package net.aihelp.data.localize.config;

import android.text.TextUtils;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.LocalizeHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.data.model.config.BusinessLogicEntity;
import net.aihelp.data.model.config.InitBusinessEntity;
import net.aihelp.utils.FileUtil;

public enum InitBusinessHelper {

    INSTANCE;

    public void prepareDataSource() {
        try {
            // 从本地读取样式配置文件
            String content = FileUtil.getContentFromFile(LocalizeUtil.getFileLocation(LocalizeHelper.MODE_INIT_BUSINESS_LOGIC));
            if (!TextUtils.isEmpty(content)) {
                InitBusinessEntity logicEntity = JsonHelper.toJavaObject(content, InitBusinessEntity.class);
                if (logicEntity != null) {

                    CustomConfig.InitSetting.screenOrientation = logicEntity.getDirection();
                    CustomConfig.InitSetting.privacyControlData = logicEntity.getInformation();

                    if (logicEntity.getFaqEvaluation() != null) {
                        CustomConfig.InitSetting.isEvaluationForBotEnable = logicEntity.getFaqEvaluation().isOnlineValid();
                        CustomConfig.InitSetting.isEvaluationForAnswerPageEnable = logicEntity.getFaqEvaluation().isFaqDetailValid();
                        CustomConfig.InitSetting.isFaqUnhelpfulFeedbackEnable = logicEntity.getFaqEvaluation().isSuggestionValid();
                        CustomConfig.InitSetting.isEvaluationForOperationEnable = logicEntity.getFaqEvaluation().isOperateDetailValid();
                    }

                    if (logicEntity.getSatisfied() != null) {
                        CustomConfig.InitSetting.isTicketRatingEnable = logicEntity.getSatisfied().isValid();
                        CustomConfig.InitSetting.isEvaluateBadServiceEnable = logicEntity.getSatisfied().isFeedback();
                        CustomConfig.InitSetting.csEvaluateMaxCount = logicEntity.getSatisfied().getFeedbackMax();
                    }

                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
