package net.aihelp.data.localize.config;

import android.text.TextUtils;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.LocalizeHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.data.model.config.BusinessLogicEntity;
import net.aihelp.utils.FileUtil;

public enum TemplateBusinessHelper {

    INSTANCE;

    public void prepareDataSource() {
        try {
            // 从本地读取样式配置文件
            String content = FileUtil.getContentFromFile(LocalizeUtil.getFileLocation(LocalizeHelper.MODE_TEMPLATE_BUSINESS_LOGIC));
            if (!TextUtils.isEmpty(content)) {
                BusinessLogicEntity logicEntity = JsonHelper.toJavaObject(content, BusinessLogicEntity.class);
                if (logicEntity != null) {
                    prepareCommonConfig(logicEntity.getGeneral());
                    prepareHelpCenterConfig(logicEntity.getHelp());
                    prepareCustomerServiceConfig(logicEntity.getOnLine());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void prepareCommonConfig(BusinessLogicEntity.GeneralEntity entity) {
        CustomConfig.CommonSetting.isBackgroundRenderedWithImage = entity.getBgOptions() == BusinessLogicEntity.GeneralEntity.BG_OPTION_IMAGE;
    }

    private void prepareHelpCenterConfig(BusinessLogicEntity.HelpEntity entity) {
        // 标题和搜索区域
        CustomConfig.HelpCenter.isFaqTitleIconVisible = entity.getIsTitleIconValid();
        CustomConfig.HelpCenter.isFaqSearchVisible = entity.getIsSearchValid();

        // 通知栏
        if (entity.getNoticeBar() != null) {
            CustomConfig.HelpCenter.isFaqNotificationVisible = entity.getNoticeBar().getIsNoticeValid();
            CustomConfig.HelpCenter.isFaqNotificationIconVisible = entity.getNoticeBar().getIsNoticeIconValid();
            CustomConfig.HelpCenter.faqNotificationInterval = entity.getNoticeBar().getIntervals();
        }

        // 热门问题
        if (entity.getFaqList() != null) {
            CustomConfig.HelpCenter.isFaqHotTopicVisible = entity.getFaqList().getIsFaqListValid();
            CustomConfig.HelpCenter.isFaqHotTopicTitleVisible = entity.getFaqList().getIsTitleValid();
            CustomConfig.HelpCenter.isFaqHotTopicTitleIconVisible = entity.getFaqList().getIsTitleIconValid();
            CustomConfig.HelpCenter.isFaqHotTopicItemIconVisible = entity.getFaqList().getIsFaqIconValid();
        }

        // FAQ分类
        if (entity.getFaqSectionList() != null) {
            CustomConfig.HelpCenter.isFaqSectionTitleVisible = entity.getFaqSectionList().getIsTitleValid();
            CustomConfig.HelpCenter.isFaqSectionTitleIconVisible = entity.getFaqSectionList().getIsTitleIconValid();
            CustomConfig.HelpCenter.isFaqSectionItemIconVisible = entity.getFaqSectionList().getIsFaqIconValid();
            CustomConfig.HelpCenter.isFaqSectionDisplayAsList = entity.getFaqSectionList().getArrangement() == BusinessLogicEntity.HelpEntity.ARRANGEMENT_LIST;
        }
    }

    private void prepareCustomerServiceConfig(BusinessLogicEntity.OnLineEntity entity) {
        // 客服模块相关
        CustomConfig.CustomerService.isCsTitleIconVisible = entity.getIsNavBarTitleIconValid();
        CustomConfig.CustomerService.isPortraitVisible = entity.getIsHeadValid();
        CustomConfig.CustomerService.isNicknameVisible = entity.getIsExternalName();
        CustomConfig.CustomerService.isMessageTimestampVisible = entity.getIsSendTime();
        if (entity.getHistoryTicket() != null) {
            CustomConfig.CustomerService.isHistoryChatEnable = entity.getHistoryTicket().getIsValid();
        }
    }

}
