package net.aihelp.data.localize.data;

import android.text.TextUtils;

import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.LocalizeHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.utils.FileUtil;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public enum LocaleStringHelper {

    INSTANCE;

    private final Map<String, String> stringMap = new HashMap<>();

    public void reset() {
        stringMap.clear();
    }

    public void prepareDataSource() {
        try {
            // 从本地读取 FAQ 文件
            String content = FileUtil.getContentFromFile(LocalizeUtil.getFileLocation(LocalizeHelper.MODE_INIT_LOCALE));
            if (!TextUtils.isEmpty(content)) {
                JSONArray jsonArray = new JSONArray(content);
                for (int i = 0; i < jsonArray.length(); i++) {
                    JSONObject jsonObject = JsonHelper.getJsonObject(jsonArray, i);
                    stringMap.put(jsonObject.optString("code"), jsonObject.optString("value"));
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getString(String key) {
        return stringMap.get(key);
    }

}
