package net.aihelp.data.logic;

import android.content.Context;
import android.text.TextUtils;

import net.aihelp.common.API;
import net.aihelp.core.mvp.AbsPresenter;
import net.aihelp.core.mvp.IRepository;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.config.FeedbackOpinionHelper;
import net.aihelp.data.model.task.ReplyMessage;
import net.aihelp.data.model.task.TaskDetailEntity;
import net.aihelp.ui.task.detail.TaskDetailFragment;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class TaskDetailPresenter extends AbsPresenter<TaskDetailFragment, IRepository> {

    public TaskDetailPresenter(Context context) {
        super(context);
    }

    public void requestTaskContent(String taskCode) {
        JSONObject params = JsonHelper.getJsonObject();
        JsonHelper.put(params, "taskCode", taskCode);
        AIHelpRequest.getInstance().requestGetByAsync(API.TICKET_CONTENT, params, new ReqCallback<TaskDetailEntity>() {
            @Override
            public void onReqSuccess(TaskDetailEntity entity) {
                if (mView != null) {
                    FeedbackOpinionHelper.INSTANCE.prepareDataSource(JsonHelper.getJsonArray(entity.getSatisfyFeedbackSetting()));
                    boolean isLastStep = entity.getStatusList().indexOf(entity.getStatus()) == entity.getStatusList().size() - 1;
                    entity.setTaskFinished(isLastStep);
                    mView.refreshTaskContent(entity, getReplyMessageList(entity));
                }
            }
        });
    }

    public void onUserReply(String taskCode, String reply, int inputFormat) {
        JSONObject params = JsonHelper.getJsonObject();
        JsonHelper.put(params, "taskCode", taskCode);
        JsonHelper.put(params, "input", reply);
        JsonHelper.put(params, "inputFormat", inputFormat);
        AIHelpRequest.getInstance().requestPostByJson(API.TICKET_MESSAGE, params, new ReqCallback<String>() {
            @Override
            public void onReqSuccess(String result) {

            }
        });
    }

    private List<ReplyMessage> getReplyMessageList(TaskDetailEntity entity) {
        // 处理普通的消息列表
        String jsonString = entity.getMessageList();
        ArrayList<ReplyMessage> list = new ArrayList<>();
        JSONArray jsonArray = JsonHelper.getJsonArray(jsonString);
        for (int i = jsonArray.length() - 1; i >= 0; i--) {
            JSONObject jsonObject = JsonHelper.getJsonObject(jsonArray, i);
            String content = JsonHelper.opt(jsonObject, "content", "");
            long createTime = JsonHelper.opt(jsonObject, "createTime", 0L);
            int replyType = JsonHelper.opt(jsonObject, "replyType", 0);

            if (!TextUtils.isEmpty(content)) {
                ReplyMessage replyMessage = new ReplyMessage();
                replyMessage.setReplyType(replyType);
                replyMessage.setTimeStamp(createTime);
                replyMessage.setContent(content);
                list.add(replyMessage);
            }
        }
        // 检查是否有满意度评价，如果有构建一条对应类型的新消息
        if (entity.isEvaluate()) {
            list.add(buildEvaluationMessage(entity.getStar(), entity.getRatingMsg(), entity.getEvaluationTime()));
        }
        return list;
    }

    public void onUserFeedback(String taskCode, boolean helpful, int count) {
        JSONObject params = JsonHelper.getJsonObject();
        JsonHelper.put(params, "taskCode", taskCode);
        JsonHelper.put(params, "type", helpful ? 1 : 2);
        JsonHelper.put(params, "count", count);
        post(API.TICKET_FEEDBACK, params, new ReqCallback<String>() {
            @Override
            public void onReqSuccess(String result) {

            }
        });
    }

    public void onUserEvaluate(String taskCode, int star, String ratingChoose, String ratingMsg) {
        JSONObject params = JsonHelper.getJsonObject();
        JsonHelper.put(params, "taskCode", taskCode);
        JsonHelper.put(params, "star", star);
        JsonHelper.put(params, "ratingChoose", ratingChoose);
        JsonHelper.put(params, "ratingMsg", ratingMsg);
        post(API.TICKET_EVALUATE, params, new ReqCallback<String>() {
            @Override
            public void onReqSuccess(String result) {
                mView.updateRatingStatus(true );
            }
        });
    }

    public ReplyMessage buildEvaluationMessage(int star, String ratingMsg, long evaluationTime) {
        ReplyMessage replyMessage = new ReplyMessage();
        replyMessage.setStar(star);
        replyMessage.setContent(ratingMsg);
        replyMessage.setTimeStamp(evaluationTime);
        replyMessage.setMsgType(ReplyMessage.MSG_TYPE_EVALUATION);
        return replyMessage;
    }

}