package net.aihelp.data.model.cs;

public class ChatInfoEntity implements Comparable<ChatInfoEntity> {

    public static final int TYPE_TIMESTAMP = 1;
    public static final int TYPE_USER = 2;
    public static final int TYPE_BOT = 3;
    public static final int TYPE_AGENT = 4;

    private long timeStamp;
    private int msgType;
    private int userId = -1;
    private String agentName;
    private String agentNickname;
    private String message;

    public int getUserId() {
        return userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public String getAgentNickname() {
        return agentNickname;
    }

    public void setAgentNickname(String agentNickname) {
        this.agentNickname = agentNickname;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public long getTimeStamp() {
        return timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public int getMsgType() {
        return msgType;
    }

    public void setMsgType(int msgType) {
        this.msgType = msgType;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public int compareTo(ChatInfoEntity historyEntity) {
        return timeStamp < historyEntity.getTimeStamp() ? -1 : 1;
    }
}
