package net.aihelp.data.model.faq;


import android.text.TextUtils;

public class FaqContentEntity {

    private String secId;
    private String faqTitle;
    private String faqKeywords;
    private String faqMainId;
    private String faqDisplayId;
    private String faqContentId;
    private String faqContent;
    private String faqNoHtmlContent;
    private int isHelpful;
    private String searchTerm;
    private String similarQuestions;
    private long lastUpdateTime;

    private String iconUrl;
    private String sectionName;

    public FaqContentEntity() {
    }

    public FaqContentEntity(String secId, String faqTitle, String faqKeywords, String faqMainId, String faqDisplayId,
                            String faqContentId, String faqContent, int isHelpful, String searchTerm) {
        this.secId = secId;
        this.faqTitle = faqTitle;
        this.faqKeywords = faqKeywords;
        this.faqMainId = faqMainId;
        this.faqDisplayId = faqDisplayId;
        this.faqContentId = faqContentId;
        this.faqContent = faqContent;
        this.isHelpful = isHelpful;
        this.searchTerm = searchTerm;
    }

    public String getIconUrl() {
        return iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getSectionName() {
        return sectionName;
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }

    public String getFaqDisplayId() {
        return faqDisplayId;
    }

    public void setFaqDisplayId(String faqDisplayId) {
        this.faqDisplayId = faqDisplayId;
    }

    public String getFaqContentId() {
        return faqContentId;
    }

    public void setFaqContentId(String faqContentId) {
        this.faqContentId = faqContentId;
    }

    public int isHelpful() {
        return isHelpful;
    }

    public void setHelpful(int helpful) {
        isHelpful = helpful;
    }

    public String getSearchTerm() {
        return searchTerm;
    }

    public void setSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
    }

    public void clearSearchTerms() {
        this.searchTerm = null;
    }

    public void updateSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
    }

    public String getFaqNoHtmlContent() {
        return faqNoHtmlContent;
    }

    public void setFaqNoHtmlContent(String faqNoHtmlContent) {
        this.faqNoHtmlContent = faqNoHtmlContent;
    }

    public String getSecId() {
        return secId;
    }

    public void setSecId(String secId) {
        this.secId = secId;
    }

    public String getFaqTitle() {
        if (TextUtils.isEmpty(faqTitle)) {
            return "";
        }
        return faqTitle;
    }

    public void setFaqTitle(String faqTitle) {
        this.faqTitle = faqTitle;
    }

    public String getFaqMainId() {
        return faqMainId;
    }

    public void setFaqMainId(String faqMainId) {
        this.faqMainId = faqMainId;
    }

    public String getFaqContent() {
        return faqContent;
    }

    public void setFaqContent(String faqContent) {
        this.faqContent = faqContent;
    }

    public String getFaqKeywords() {
        return faqKeywords;
    }

    public void setFaqKeywords(String faqKeywords) {
        this.faqKeywords = faqKeywords;
    }

    public int getIsHelpful() {
        return isHelpful;
    }

    public void setIsHelpful(int isHelpful) {
        this.isHelpful = isHelpful;
    }

    public String getSimilarQuestions() {
        if (TextUtils.isEmpty(similarQuestions)) {
            return "";
        }
        return similarQuestions;
    }

    public void setSimilarQuestions(String similarQuestions) {
        this.similarQuestions = similarQuestions;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public long getLastUpdateTime() {
        return lastUpdateTime;
    }
}
