package net.aihelp.data.model.faq;

import android.text.TextUtils;

import java.lang.reflect.Field;

public class FaqListEntity implements Comparable<FaqListEntity> {

    public static final int FAQ_DISPLAY_SECTION = 1;
    public static final int FAQ_DISPLAY_SUB_SECTION = 2;
    public static final int FAQ_DISPLAY_QUESTION_LIST = 3;
    public static final int FAQ_DISPLAY_SEARCH = 4;
    public static final int FAQ_DISPLAY_NOTIFICATION = 5;
    public static final int FAQ_DISPLAY_HOT_TOPICS = 6;

    /**
     * 当前列表的类型，可能是：
     * 1、顶级分类列表页；2、子分类列表页；3、faq 问题列表页；4、搜索结果列表页；5、通知列表；6、帮助中心热门问题列表；
     */
    private int displayType;

    /**
     * faq 列表的 id，可能是 sectionId，也可能是 faqId
     */
    private String id;

    /**
     * faq 列表项的标题，可能是分类的名称，也可能是 faq 的标题
     */
    private String title;

    /**
     * 搜索关键词，用于标记高亮
     */
    private String query;

    /**
     * 排序规则
     */
    private int order;

    /**
     * icon 图标
     */
    private String iconUrl;

    /**
     * 所在分类标题
     */
    private String sectionName;

    private boolean isHidden;

    public FaqListEntity(int displayType, String id, String title) {
        this.displayType = displayType;
        this.id = id;
        this.title = title;
    }

    public FaqListEntity(int displayType, String id, String title, String query) {
        this.displayType = displayType;
        this.id = id;
        this.title = title;
        this.query = query;
    }

    public FaqListEntity(int displayType, String id, String title, String query, String iconUrl) {
        this.displayType = displayType;
        this.id = id;
        this.title = title;
        this.query = query;
        this.iconUrl = iconUrl;
    }

    public boolean isHidden() {
        return isHidden;
    }

    public void setHidden(boolean hidden) {
        isHidden = hidden;
    }

    public String getSectionName() {
        return sectionName;
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }

    public int getDisplayType() {
        return displayType;
    }

    public void setDisplayType(int displayType) {
        this.displayType = displayType;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getQuery() {
        return query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public int getOrder() {
        return order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getIconUrl() {
        return iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    @Override
    public String toString() {
        return "FaqInfo{" +
                "source=" + getDisplayTypeDesc(displayType) +
                ", id='" + id + '\'' +
                ", title='" + title + '\'' +
                ", query='" + query + '\'' +
                ", sectionTitle='" + sectionName + '\'' +
                '}';
    }

    private String getDisplayTypeDesc(int type) {
        Field[] declaredFields = FaqListEntity.class.getDeclaredFields();
        for (Field declaredField : declaredFields) {
            declaredField.setAccessible(true);
            try {
                int value = declaredField.getInt(null);
                if (value == type) {
                    String fieldName = declaredField.getName();
                    if (!TextUtils.isEmpty(fieldName)) {
                        return fieldName.replace("FAQ_DISPLAY_", "");
                    }
                }
            } catch (Exception e) {
                // ignored
            }
        }
        return "";
    }

    @Override
    public int compareTo(FaqListEntity o) {
        return this.order - o.order;
    }

}
