package net.aihelp.data.model.rpa.msg;

import android.text.TextUtils;

import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.msg.bot.Answer;
import net.aihelp.data.model.rpa.msg.bot.ExternalUrl;
import net.aihelp.data.model.rpa.msg.bot.Faq;
import net.aihelp.data.model.rpa.msg.bot.FormUrl;
import net.aihelp.data.model.rpa.msg.bot.SelfService;
import net.aihelp.utils.ListUtil;

import java.util.List;

public class BotMessage extends Message {

    public static final int USER_FEEDBACK_INVISIBLE = -1;
    public static final int USER_FEEDBACK_NONE = 0;
    public static final int USER_FEEDBACK_POSITIVE = 1;
    public static final int USER_FEEDBACK_NEGATIVE = 2;

    public BotMessage(String nickname) {
        setNickname(nickname);
    }

    private FormUrl formUrl;
    private ExternalUrl externalUrl;
    private Faq faq;
    private SelfService selfService;
    private List<Answer> botAnswers;
    private int userFeedback;

    public FormUrl getFormUrl() {
        return formUrl;
    }

    public void setFormUrl(FormUrl formUrl) {
        this.formUrl = formUrl;
    }

    public ExternalUrl getExternalUrl() {
        return externalUrl;
    }

    public void setExternalUrl(ExternalUrl externalUrl) {
        this.externalUrl = externalUrl;
    }

    public Faq getFaq() {
        return faq;
    }

    public void setFaq(Faq faq) {
        this.faq = faq;
        if (hasFaq()) {
            setMsgType(TYPE_AGENT_RPA_FAQ);
        }
    }

    public SelfService getSelfService() {
        return selfService;
    }

    public void setSelfService(SelfService selfService) {
        this.selfService = selfService;
        if (hasSelfService() && selfService.isEnableSend()) {
            setNormalMessage(false);
        }
    }

    public List<Answer> getBotAnswers() {
        return botAnswers;
    }

    public void setBotAnswers(List<Answer> botAnswers) {
        this.botAnswers = botAnswers;
        if (hasBotAnswers()) {
            setMsgType(TYPE_AGENT_BOT_ANSWER);
        }
    }

    public int getUserFeedback() {
        return userFeedback;
    }

    public void setUserFeedback(int userFeedback) {
        this.userFeedback = userFeedback;
    }

    @Override
    public void setContent(String content) {
        super.setContent(content);
        setMsgType(TYPE_AGENT_TEXT);
    }

    public boolean hasFormUrl() {
        return formUrl != null && !TextUtils.isEmpty(formUrl.getLink()) && !TextUtils.isEmpty(formUrl.getTitle());
    }

    public boolean hasExternalUrl() {
        return externalUrl != null && !TextUtils.isEmpty(externalUrl.getLink()) && !TextUtils.isEmpty(externalUrl.getTitle());
    }

    public boolean hasFaq() {
        return faq != null && !ListUtil.isListEmpty(faq.getFaqDataList());
    }

    public boolean hasSelfService() {
        return selfService != null && !TextUtils.isEmpty(selfService.getSelfServiceData()) && !"[]".equals(selfService.getSelfServiceData());
    }

    public boolean hasBotAnswers() {
        return !ListUtil.isListEmpty(botAnswers);
    }

}
