package net.aihelp.data.model.rpa.msg.agent;

import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.model.rpa.msg.base.FileMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.cs.util.rpa.factory.MessageFactory;
import net.aihelp.utils.RegexUtil;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AgentRichMessage extends Message {

    private List<Message> messageList;

    public AgentRichMessage(String nickname) {
        setNickname(nickname);
        setMsgType(Message.TYPE_AGENT_RICH_TEXT);
    }

    public void setMessageList(String message) {
        ArrayList<Message> arrayList = new ArrayList<>();

        // text message
        String content = MessageFactory.getPeeledContent(message);

        // 使用正则匹配返回的信息，里边可能有表单、图片、普通文字等，并将匹配到的位置信息存到数组中
        LinkedList<Integer> urlIndexList = new LinkedList<>();
        urlIndexList.add(0);
        Matcher formMatcher = Pattern.compile(RegexUtil.REGEX_RICH_TEXT).matcher(content);
        while (formMatcher.find()) {
            urlIndexList.add(formMatcher.start());
            urlIndexList.add(formMatcher.end());
        }
        if (urlIndexList.getLast() != content.length()) {
            urlIndexList.add(content.length());
        }

        for (int i = 0; i < urlIndexList.size() - 1; i++) {
            final String urlOrRawText = content.substring(urlIndexList.get(i), urlIndexList.get(i + 1)).trim();
            if (Pattern.compile("\\s*?").matcher(urlOrRawText).matches()) {
                continue;
            }
            if (Pattern.compile(RegexUtil.REGEX_IMAGE).matcher(urlOrRawText).matches()) {
                arrayList.add(new FileMessage(Message.TYPE_AGENT_IMAGE, urlOrRawText));
            } else if (Pattern.compile(RegexUtil.REGEX_VIDEO).matcher(urlOrRawText).matches()) {
                arrayList.add(new FileMessage(Message.TYPE_AGENT_VIDEO, urlOrRawText));
            } else {
                AgentMessage textMessage = new AgentMessage(Message.TYPE_AGENT_TEXT);
                textMessage.setContent(urlOrRawText);
                arrayList.add(textMessage);
            }
        }

        // attachments list
        JSONObject contentObject = MessageFactory.getContentObject(JsonHelper.getJsonObject(message));
        JSONArray attachments = JsonHelper.getJsonArray(contentObject, "attachments");
        for (int i = 0; i < attachments.length(); i++) {
            JSONObject attachItem = JsonHelper.getJsonObject(attachments, i);
            String fileUrl = JsonHelper.optString(attachItem, "url");
            String fileName = JsonHelper.optString(attachItem, "filename");
            int fileSize = attachItem.optInt("size", 0);
            int msgType = Message.TYPE_AGENT_FILE;
            if (RegexUtil.isImageFile(fileUrl)) {
                msgType = Message.TYPE_AGENT_IMAGE;
            } else if (RegexUtil.isVideoFile(fileUrl)) {
                msgType = Message.TYPE_AGENT_VIDEO;
            }
            FileMessage fileMessage = new FileMessage(msgType, fileUrl);
            fileMessage.setFileInfo(fileName, fileSize);
            fileMessage.setNormalMessage(true);
            arrayList.add(fileMessage);
        }

        this.messageList = arrayList;
    }

    public List<Message> getMessageList() {
        return messageList;
    }

}
