package net.aihelp.data.model.rpa.msg.bot;

import android.text.TextUtils;

import net.aihelp.BuildConfig;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;

import java.util.List;

public class Faq {

    public final static int FAQ_SOURCE_RPA = 1;
    public final static int FAQ_SOURCE_ANSWER_BOT = 2;

    private final List<Faq.FaqData> faqDataList;

    public Faq(boolean isSimilarMatch, List<Faq.FaqData> faqDataList) {
        this.faqDataList = faqDataList;
    }

    public List<Faq.FaqData> getFaqDataList() {
        return faqDataList;
    }

    public static class FaqData {

        public FaqData(int faqSource, long mainId, long contentId, String faqTitle, String faqContent,
                       String template, String formUrl, String formTitle, boolean isSimilarMatch, boolean isShowMore) {
            this.faqSource = faqSource;
            this.mainId = mainId;
            this.contentId = contentId;
            this.faqTitle = faqTitle;
            this.faqContent = faqContent;
            this.template = TextUtils.isEmpty(template) ? "" : template.trim();
            this.formUrl = FormUrl.getFormattedFormUrl(formUrl);;
            this.formTitle = formTitle;
            this.isSimilarMatch = isSimilarMatch;
            this.isShowMore = isShowMore;
        }

        private int faqSource;
        private final long mainId;
        private final long contentId;
        private final String faqTitle;
        private final String faqContent;
        private final String template;
        private final String formUrl;
        private final String formTitle;
        private final boolean isSimilarMatch;
        private final boolean isShowMore;

        private boolean isFaqViewed;
        private boolean isFaqEvaluated;

        public boolean isFaqEvaluated() {
            return isFaqEvaluated;
        }

        public void setFaqEvaluated(boolean faqEvaluated) {
            isFaqEvaluated = faqEvaluated;
        }

        public boolean isFaqViewed() {
            return isFaqViewed;
        }

        public void setFaqViewed(boolean faqViewed) {
            isFaqViewed = faqViewed;
        }

        public long getMainId() {
            return mainId;
        }

        public long getContentId() {
            return contentId;
        }

        public String getFaqContent() {
            return faqContent;
        }

        public String getFaqTitle() {
            return faqTitle;
        }

        public String getTemplate() {
            return template;
        }

        public String getFormUrl() {
            return formUrl;
        }

        public String getFormTitle() {
            return formTitle;
        }

        public boolean hasAttachedForm() {
            return !TextUtils.isEmpty(formUrl) && !TextUtils.isEmpty(formTitle);
        }

        public boolean isSimilarMatch() {
            return isSimilarMatch;
        }

        public boolean isShowMore() {
            return isShowMore;
        }

        public int getFaqSource() {
            return faqSource;
        }

        public void setFaqSource(int faqSource) {
            this.faqSource = faqSource;
        }
    }

}
