package net.aihelp.data.model.rpa.msg.bot;

import android.text.TextUtils;

import net.aihelp.BuildConfig;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.data.localize.config.ProcessEntranceHelper;

public class FormUrl {
    private final String title;
    private final String link;

    public FormUrl(String title, String link) {
        this.title = title;
        this.link = getFormattedFormUrl(link);
    }

    public String getTitle() {
        return title;
    }

    public String getLink() {
        return link;
    }

    public static String getFormattedFormUrl(String url) {
        if (!TextUtils.isEmpty(url)) {
            return String.format("%s&appId=%s&userId=%s&serverId=%s&platform=%s&sdkVersion=%s&isTicket=1&hasPermission=%s&fromSdk=1&isCustom=1&templateId=%s",
                    url,
                    Const.APP_ID,
                    UserProfile.USER_ID,
                    UserProfile.SERVER_ID,
                    BuildConfig.SDK_PLATFORM,
                    BuildConfig.SDK_VERSION,
                    0,
                    ProcessEntranceHelper.INSTANCE.getCurrentProcess().getTemplateId()
            );
        }
        return "";
    }
}
