package net.aihelp.data.model.task;

import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.text.TextUtils;

import net.aihelp.ui.helper.BitmapHelper;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.MediaUtils;
import net.aihelp.utils.RegexUtil;
import net.aihelp.utils.TLog;

import java.io.File;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.regex.Pattern;

public class ReplyMessage {

    public static final int REPLY_TYPE_AGENT = 2;
    public static final int REPLY_TYPE_USER = 3;

    public static final int MSG_TYPE_TEXT = 1;
    public static final int MSG_TYPE_IMAGE = 2;
    public static final int MSG_TYPE_VIDEO = 3;
    public static final int MSG_TYPE_FILE = 4;
    public static final int MSG_TYPE_EVALUATION = 5;

    public static final int STATUS_NORMAL = 1;
    public static final int STATUS_SENDING = 2;
    public static final int STATUS_FAILURE = 3;

    private int replyType;
    private int msgType;
    private long timeStamp;
    private int msgStatus = STATUS_NORMAL;
    private String content = "";
    private String videoThumbnail;
    private int[] imageSize;
    private String fileName;
    private long fileSize;
    private int star;

    public int getReplyType() {
        return replyType;
    }

    public void setReplyType(int replyType) {
        this.replyType = replyType;
    }

    public int getMsgType() {
        return msgType;
    }

    public void setMsgType(int msgType) {
        this.msgType = msgType;
    }

    public long getTimeStamp() {
        return timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        int msgType = MSG_TYPE_TEXT;
        if (!TextUtils.isEmpty(content)) {
            if (Pattern.compile(RegexUtil.REGEX_IMAGE).matcher(content).matches()) {
                msgType = MSG_TYPE_IMAGE;
            } else if (Pattern.compile(RegexUtil.REGEX_VIDEO).matcher(content).matches()) {
                msgType = MSG_TYPE_VIDEO;
            }
        }
        setMsgType(msgType);
        this.content = content;
    }

    public void setFileInfo(String fileName, long fileSize) {
        this.fileName = fileName;
        this.fileSize = fileSize;
    }

    public String getFileSize() {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString;
        String wrongSize = "0B";
        if (fileSize == 0) {
            return wrongSize;
        }
        if (fileSize < 1024) {
            fileSizeString = fileSize + "B";
        } else if (fileSize < 1048576) {
            fileSizeString = df.format((double) fileSize / 1024) + "KB";
        } else if (fileSize < 1073741824) {
            fileSizeString = df.format((double) fileSize / 1048576) + "MB";
        } else {
            fileSizeString = df.format((double) fileSize / 1073741824) + "GB";
        }
        return fileSizeString;
    }

    public String getFileName() {
        return fileName;
    }

    public int getMsgStatus() {
        return msgStatus;
    }

    public void setMsgStatus(int msgStatus) {
        this.msgStatus = msgStatus;
    }

    public String getVideoThumbnail() {
        return videoThumbnail;
    }

    public void setVideoThumbnail(String videoThumbnail) {
        this.videoThumbnail = videoThumbnail;
        setImageSize(BitmapHelper.computeSize(videoThumbnail));
    }

    public int[] getImageSize() {
        return imageSize;
    }

    public void setImageSize(int[] imageSize) {
        this.imageSize = imageSize;
    }

    public int getStar() {
        return star;
    }

    public void setStar(int star) {
        this.star = star;
    }

    public void prepareVideoThumbnail() {
        String correctContent = DomainSupportHelper.getAdjustedUrl(getContent());
        String videoThumbnail = MediaUtils.getImageForVideoSync(correctContent);
        setVideoThumbnail(videoThumbnail);
    }

    public int getReplyFormat() {
        if (msgType == MSG_TYPE_TEXT) {
            return 1;
        }
        return 2;
    }

}
