package net.aihelp.data.track.event;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;

import net.aihelp.BuildConfig;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.IntentValues;
import net.aihelp.common.UserProfile;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.UploadCallback;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.track.event.utils.EventHelper;
import net.aihelp.data.track.event.utils.EventType;
import net.aihelp.data.track.ue.UETracker;
import net.aihelp.init.AIHelpSupport;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.DateFormatUtil;
import net.aihelp.utils.DeviceInfoUtil;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.TLog;
import net.aihelp.utils.ToastUtil;
import net.aihelp.utils.UploadFileHelper;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;

public enum EventTracker {

    INSTANCE;

    private final int mSampleRandomCount;
    private boolean isTargeted = false;

    EventTracker() {
        mSampleRandomCount = new Random().nextInt(1000000);
    }

    public void log(int type, Object... extraData) {
        if (isTargeted) {
            // EventHelper.INSTANCE.logEventInfoFile(type, extraData);
        }
    }

    public JSONArray getEventArray() {
        return EventHelper.INSTANCE.getJsonArray();
    }

    public void reset(Context context) {
        EventHelper.INSTANCE.reset();

        ApiExecutorFactory.getHandlerExecutor().runOnUiThreadDelayed(new Runnable() {
            @Override
            public void run() {
                JSONObject resultObject = JsonHelper.getJsonObject();
                try {
                    resultObject.put("sampleRate", 1000000);
                } catch (JSONException e) {
                    e.printStackTrace();
                }

                // get sample rate, otherwise check if current device is targeted
                int sampleRateValue = resultObject.optInt("sampleRate", -1);
                if (mSampleRandomCount <= sampleRateValue) {
                    isTargeted = true;
                } else {
                    String deviceId = DeviceUuidFactory.id(context);
                    JSONArray deviceIds = JsonHelper.getJsonArray(resultObject, "deviceIds");
                    for (int i = 0; i < deviceIds.length(); i++) {
                        String id = deviceIds.optString(i);
                        if (deviceId.equals(id)) {
                            isTargeted = true;
                            break;
                        }
                    }
                }

                if (isTargeted) {
                    EventTracker.INSTANCE.log(EventType.TRACK_STARTED,
                            "appId", Const.APP_ID,
                            "deviceId", DeviceUuidFactory.id(context),
                            "deviceInfo", String.format("%s %s %s", Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE),
                            "sdkVersion", BuildConfig.SDK_VERSION,
                            "originLanguage", Const.ORIGINAL_LANGUAGE,
                            "countryCode", DeviceInfoUtil.getInstance().getSimCountryIso(),
                            "timeZone", new Date().toString()
                    );
                }

            }
        }, 500);

//        AIHelpRequest.getInstance().requestPostByJson(API.GET_DEVICE_FILTERS, "", new ReqCallback<String>() {
//            @Override
//            public void onReqSuccess(String result) {
//                JSONObject resultObject = JsonHelper.getJsonObject(result);
//
//                // get sample rate, otherwise check if current device is targeted
//                int sampleRateValue = resultObject.optInt("sampleRate", -1);
//                if (mSampleRandomCount <= sampleRateValue) {
//                    isTargeted = true;
//                } else {
//                    String deviceId = DeviceUuidFactory.id(context);
//                    JSONArray deviceIds = JsonHelper.getJsonArray(resultObject, "deviceIds");
//                    for (int i = 0; i < deviceIds.length(); i++) {
//                        String id = deviceIds.optString(i);
//                        if (deviceId.equals(id)) {
//                            isTargeted = true;
//                            break;
//                        }
//                    }
//                }
//
//                if (isTargeted) {
//                    EventTracker.INSTANCE.log(EventType.TRACK_STARTED,
//                            "appId", Const.APP_ID,
//                            "deviceId", DeviceUuidFactory.id(context),
//                            "userId", UserProfile.USER_ID,
//                            "sdkVersion", BuildConfig.SDK_VERSION,
//                            "originLanguage", Const.ORIGINAL_LANGUAGE,
//                            "countryCode", DeviceInfoUtil.getInstance().getSimCountryIso()
//                    );
//                }
//            }
//        });

        tryUploadingEventLog(context, false);
    }

    public void tryUploadingEventLog(Context context, boolean breakRelease) {
        // TODO: 2023/5/26 make this upload api to support .json file
        File eventLog = new File(EventHelper.INSTANCE.getFilePath(context));
        if (eventLog.exists() && eventLog.length() > 0) {

            // calculate user experience data before uploading the event log
            UETracker.calculateUETrack();

            if (breakRelease) {
                ToastUtil.INSTANCE.makeRawToast(context, "Powered by AIHELP.NET");
            }
            UploadFileHelper.INSTANCE.setOnUploadFileListener(new UploadFileHelper.OnUploadFileListener() {
                @Override
                public void onFileUploaded(String fileUrl) {
                    if (BuildConfig.DEBUG && breakRelease) {
                        AppInfoUtil.openWithBrowser(context, fileUrl);
                    }
                    // TODO: figure out a way to get the url from users when debugging some bugs
                }
            }).performUpload(eventLog);

        }
    }

}

