package net.aihelp.data.track.event.utils;

import java.lang.reflect.Field;

public class EventType {

    public static final int TRACK_STARTED = 100;

    public static final int API_SHOW = 101;
    public static final int API_SHOW_SINGLE_FAQ = 102;
    public static final int API_UPDATE_USER_INFO = 104;
    public static final int API_UPDATE_SDK_LANGUAGE = 105;

    public static final int HC_PAGE_HOME_OPENED = 200;
    public static final int HC_PAGE_HOME_CLOSED = 201;
    public static final int HC_PAGE_LIST_OPENED = 202;
    public static final int HC_PAGE_LIST_CLOSED = 203;
    public static final int HC_PAGE_CONTENT_OPENED = 204;
    public static final int HC_PAGE_CONTENT_CLOSED = 205;
    public static final int HC_PAGE_SEARCH_OPENED = 206;
    public static final int HC_PAGE_SEARCH_QUERY = 207;
    public static final int HC_PAGE_SEARCH_CLOSED = 208;
    public static final int HC_ACTION_CHECK_CUSTOMER_SERVICE = 209;
    public static final int HC_ACTION_MARK_FAQ_HELPFUL = 210;
    public static final int HC_ACTION_SUBMIT_FAQ_FEEDBACK = 211;

    public static final int CS_PAGE_OPENED = 300;
    public static final int CS_PAGE_CLOSED = 301;
    public static final int CS_REQUEST_LOGIN = 303;
    public static final int CS_CONNECT_MQTT = 304;
    public static final int CS_MQTT_CONNECTED = 305;
    public static final int CS_MQTT_DISCONNECTED = 306;
    public static final int CS_MQTT_CONNECT_FAILURE = 307;
    public static final int CS_MQTT_SUBSCRIBED = 308;

    public static final int CS_MESSAGE_SENT = 309;
    public static final int CS_MESSAGE_SEND_FAILED = 310;
    public static final int CS_MESSAGE_RECEIVED = 311;
    public static final int CS_GO_BACK_TO_PREVIOUS_STEP = 316;
    public static final int CS_GET_LAST_CONVERSATION = 317;
    public static final int CS_CLICK_URL = 318;

    public static final int AIHELP_CREATED = 400;
    public static final int AIHELP_DESTROYED = 401;
    public static final int ERR_NO_ENTRANCE_MATCHED = 402;
    public static final int WEB_LOAD_FINISHED = 403;
    public static final int TEMPLATE_RESOURCE_PREPARED = 404;
    public static final int SDK_CRASHED = 405;

    public static String getEventDesc(int type) {
        Field[] declaredFields = EventType.class.getDeclaredFields();
        for (Field declaredField : declaredFields) {
            declaredField.setAccessible(true);
            try {
                int value = declaredField.getInt(null);
                if (value == type) return declaredField.getName();
            } catch (Exception e) {
                // ignored
            }
        }
        return "";
    }

}
