package net.aihelp.data.track.resource;

import net.aihelp.data.localize.LocalizeHelper;
import net.aihelp.data.track.resource.tracker.InitEventTracker;
import net.aihelp.data.track.resource.tracker.InitResTracker;
import net.aihelp.data.track.resource.tracker.TemplateResTracker;

public class ResourceTracker {

    public static void markInitStarted() {
        SyncHelper.reset();
        InitEventTracker.INSTANCE.markInitStarted();
    }

    public static void markInitEnded(boolean initSuccess) {
        InitEventTracker.INSTANCE.markInitEnded(initSuccess);
    }

    public static void onResourceRequested(int resourceCount, int fetchSource) {
        if (fetchSource == LocalizeHelper.FETCH_SOURCE_INIT) {
            InitResTracker.INSTANCE.onRequested(resourceCount);
        } else if (fetchSource == LocalizeHelper.FETCH_SOURCE_TEMPLATE) {
            TemplateResTracker.INSTANCE.onRequested(resourceCount);
        }
    }

    public static void onResourceRetrieved(int mode, boolean isSuccess, int fetchSource) {
        if (fetchSource == LocalizeHelper.FETCH_SOURCE_INIT) {
            InitResTracker.INSTANCE.onRetrieved();
        } else if (fetchSource == LocalizeHelper.FETCH_SOURCE_TEMPLATE) {
            TemplateResTracker.INSTANCE.onRetrieved();
        }
        SyncHelper.syncResultToServer(mode, isSuccess, fetchSource);
    }

}
