package net.aihelp.data.track.resource.tracker;

import net.aihelp.common.API;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.data.track.resource.SyncHelper;

import java.util.HashMap;

public enum InitEventTracker {

    INSTANCE;

    private boolean isInitSuccess;
    private long initStartTime;
    private long initEndTime;
    private long initDuration;

    private HashMap<String, Long> resLoadingMap = new HashMap<>();

    public void markInitStarted() {
        this.initStartTime = System.currentTimeMillis();
    }

    public void markInitEnded(boolean initSuccess) {
        this.isInitSuccess = initSuccess;
        initEndTime = System.currentTimeMillis();
        initDuration = initEndTime - initStartTime;
        if (!initSuccess) {
            AIHelpRequest request = AIHelpRequest.getInstance();
            request.requestPostByJson(API.TRACK_LOCALIZE_DURATION_EXTREME,
                    SyncHelper.getTrackData(-1, null), null);
        }
    }

    public void reset() {
        isInitSuccess = false;
        initStartTime = 0;
        initEndTime = 0;
        resLoadingMap = new HashMap<>();
    }

    public boolean isInitSuccess() {
        return isInitSuccess;
    }

    public long getInitEndTime() {
        return initEndTime;
    }

    public long getInitDuration() {
        return initDuration;
    }

    public HashMap<String, Long> getResLoadingMap() {
        return resLoadingMap;
    }

}
