package net.aihelp.data.track.statistic;

public class TrackEntity {

    private final String entranceId;
    private final String activeId;
    private boolean isTracked;

    private long whenAIHelpVisible;
    private long whenCustomerServiceVisible;
    private long totalCustomerServiceDuration;

    private String faqMainId;
    private String faqContentId;
    private String sectionId;

    private long whenMessageSent;
    private long whenUserGetFeedback;
    private long totalWaitingDuration;

    public TrackEntity(String entranceId, String activeId) {
        this.entranceId = entranceId;
        this.activeId = activeId;
    }

    public String getEntranceId() {
        return entranceId;
    }

    public String getActiveId() {
        return activeId;
    }

    public boolean isTracked() {
        return isTracked;
    }

    public void setTracked(boolean tracked) {
        isTracked = tracked;
    }

    public long getWhenAIHelpVisible() {
        return whenAIHelpVisible;
    }

    public void setWhenAIHelpVisible(long whenAIHelpVisible) {
        this.whenAIHelpVisible = whenAIHelpVisible;
    }

    public long getWhenCustomerServiceVisible() {
        return whenCustomerServiceVisible;
    }

    public void setWhenCustomerServiceVisible(long whenCustomerServiceVisible) {
        this.whenCustomerServiceVisible = whenCustomerServiceVisible;
    }

    public long getTotalCustomerServiceDuration() {
        return totalCustomerServiceDuration;
    }

    public void calculateTotalCustomerServiceDuration() {
        this.totalCustomerServiceDuration += (System.currentTimeMillis() - whenCustomerServiceVisible);
    }

    public String getFaqMainId() {
        return faqMainId;
    }

    public void setFaqMainId(String faqMainId) {
        this.faqMainId = faqMainId;
    }

    public String getFaqContentId() {
        return faqContentId;
    }

    public void setFaqContentId(String faqContentId) {
        this.faqContentId = faqContentId;
    }

    public String getSectionId() {
        return sectionId;
    }

    public void setSectionId(String sectionId) {
        this.sectionId = sectionId;
    }

    public long getWhenMessageSent() {
        return whenMessageSent;
    }

    public void setWhenMessageSent(long whenMessageSent) {
        this.whenMessageSent = whenMessageSent;
    }

    public long getWhenUserGetFeedback() {
        return whenUserGetFeedback;
    }

    public void setWhenUserGetFeedback(long whenUserGetFeedback) {
        this.whenUserGetFeedback = whenUserGetFeedback;
    }

    public long getTotalWaitingDuration() {
        return totalWaitingDuration;
    }

    public void setTotalWaitingDuration(long totalWaitingDuration) {
        this.totalWaitingDuration = totalWaitingDuration;
    }
}
