package net.aihelp.init;

import net.aihelp.ui.listener.OnAIHelpInitializedCallback;
import net.aihelp.ui.listener.OnAIHelpSessionCloseCallback;
import net.aihelp.ui.listener.OnAIHelpSessionOpenCallback;
import net.aihelp.ui.listener.OnMessageCountArrivedCallback;
import net.aihelp.ui.listener.OnNetworkCheckResultCallback;
import net.aihelp.ui.listener.OnOperationUnreadChangedCallback;
import net.aihelp.ui.listener.OnSpecificFormSubmittedCallback;
import net.aihelp.ui.listener.OnSpecificUrlClickedCallback;


public class CallbackHelper {

    public static void registerCocos2dxCallback(final int callbackType, Object... obj) {
        switch (callbackType) {
            case 1001:
                AIHelpSupport.setOnAIHelpInitializedCallback(new OnAIHelpInitializedCallback() {
                    @Override
                    public void onAIHelpInitialized(boolean isSuccess, String message) {
                        handleCocos2dxCallback(callbackType, isSuccess, message);
                    }
                });
                break;
            case 1002:
                if (obj != null && obj.length > 0 && obj[0] instanceof String) {
                    AIHelpSupport.setNetworkCheckHostAddress((String) obj[0], new OnNetworkCheckResultCallback() {
                        @Override
                        public void onNetworkCheckResult(String netLog) {
                            handleCocos2dxCallback(callbackType, netLog);
                        }
                    });
                }
                break;
            case 1003:
                AIHelpSupport.startUnreadMessageCountPolling(new OnMessageCountArrivedCallback() {
                    @Override
                    public void onMessageCountArrived(int msgCount) {
                        handleCocos2dxCallback(callbackType, msgCount);
                    }
                });
                break;
            case 1004:
                AIHelpSupport.setOnSpecificFormSubmittedCallback(new OnSpecificFormSubmittedCallback() {
                    @Override
                    public void onFormSubmitted() {
                        handleCocos2dxCallback(callbackType);
                    }
                });
                break;
            case 1005:
                AIHelpSupport.setOnAIHelpSessionOpenCallback(new OnAIHelpSessionOpenCallback() {
                    @Override
                    public void onAIHelpSessionOpened() {
                        handleCocos2dxCallback(callbackType);
                    }
                });
                break;
            case 1006:
                AIHelpSupport.setOnAIHelpSessionCloseCallback(new OnAIHelpSessionCloseCallback() {
                    @Override
                    public void onAIHelpSessionClosed() {
                        handleCocos2dxCallback(callbackType);
                    }
                });
                break;
            case 1008:
                AIHelpSupport.setOnSpecificUrlClickedCallback(new OnSpecificUrlClickedCallback() {
                    @Override
                    public void onSpecificUrlClicked(String url) {
                        handleCocos2dxCallback(callbackType, url);
                    }
                });
        }
    }

    public static native void handleCocos2dxCallback(int callbackType, Object... obj);

}
