package net.aihelp.ui;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.IntentValues;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.ui.ActivityManager;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.data.event.FatalErrorEvent;
import net.aihelp.data.event.SearchViewVisibilityChangeEvent;
import net.aihelp.data.event.LoadingElvaEvent;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.event.PageHoppingEvent;
import net.aihelp.data.event.TaskCenterUnreadEvent;
import net.aihelp.data.event.UpdateTitleEvent;
import net.aihelp.data.track.statistic.StatisticTracker;
import net.aihelp.ui.cs.BaseCSFragment;
import net.aihelp.ui.cs.CustomerServiceFragment;
import net.aihelp.ui.cs.IntentUrlFragment;
import net.aihelp.ui.faq.BaseFaqFragment;
import net.aihelp.ui.faq.FaqContentFragment;
import net.aihelp.ui.faq.FaqHomeFragment;
import net.aihelp.ui.faq.FaqSearchFragment;
import net.aihelp.ui.faq.IFaqEventListener;
import net.aihelp.ui.faq.IFaqParentView;
import net.aihelp.ui.helper.BreakReleaseHelper;
import net.aihelp.ui.helper.FragmentHelper;
import net.aihelp.ui.helper.SupportHelper;
import net.aihelp.ui.task.TaskListFragment;
import net.aihelp.ui.task.detail.TaskDetailFragment;
import net.aihelp.ui.widget.AIHelpFakeSearch;
import net.aihelp.ui.widget.AIHelpSearchView;
import net.aihelp.ui.widget.AIHelpTaskCenterEntrance;
import net.aihelp.utils.FastClickValidator;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.Styles;

import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;

@RestrictTo(RestrictTo.Scope.LIBRARY)
public class SupportFragment extends BaseFragment implements View.OnClickListener, IFaqParentView {

    private SupportHelper mSupportHelper;

    private ImageView ivBack;
    private ImageView ivLoading;
    private ImageView ivTitle;
    private TextView tvTitle;
    private AIHelpTaskCenterEntrance taskEntrance;
    private AIHelpSearchView searchView;
    private TextView tvLogo;

    private LinearLayout fakeSearchPort;
    private AIHelpFakeSearch fakeSearchLand;

    private ObjectAnimator loadingAnimator;

    public static SupportFragment getInstance(Bundle bundle) {
        SupportFragment fraSupport = new SupportFragment();
        fraSupport.setArguments(bundle);
        return fraSupport;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (mSupportHelper == null) {
            mSupportHelper = new SupportHelper(context, getRetainedChildFragmentManager(), getArguments());
        }
    }

    @Override
    public void onResume() {
        super.onResume();
//        mSupportHelper.start();
    }

    @Override
    protected void getBundleBeforeDataPrepared(Bundle extras) {
        super.getBundleBeforeDataPrepared(extras);

        ivBack = (AppCompatImageView) get("aihelp_iv_back");
        ivBack.setOnClickListener(this);
        Styles.reRenderImageView(ivBack, "aihelp_svg_ic_back", true);

        tvLogo = (TextView) get("aihelp_logo");
        tvLogo.setVisibility((Const.TOGGLE_HIDE_BRAND ? View.GONE : View.VISIBLE));

        ivLoading = (AppCompatImageView) get("aihelp_iv_loading");
        ivTitle = (ImageView) get("aihelp_iv_title");
        tvTitle = (TextView) get("aihelp_tv_title");
        searchView = (AIHelpSearchView) get("aihelp_search_view");
        taskEntrance = (AIHelpTaskCenterEntrance) get("aihelp_feedback_entrance");
        fakeSearchPort = (LinearLayout) get("aihelp_fake_search_port");
        fakeSearchLand = (AIHelpFakeSearch) get("aihelp_fake_search_land");
        tvLogo = (TextView) get("aihelp_logo");

        loadingAnimator = ObjectAnimator.ofFloat(ivLoading, "rotation", 0F, 360F);
        loadingAnimator.setDuration(1000);
        loadingAnimator.setInterpolator(new LinearInterpolator());
        loadingAnimator.setRepeatCount(ValueAnimator.INFINITE);

//        if (!isTemplateReady) {
//            showLoading();
//        }

    }

    @Override
    protected void initEventAndData(View view) {

        RelativeLayout rlNavigation = (RelativeLayout) get("aihelp_rl_navigation");
        rlNavigation.setBackgroundColor(Styles.getColorWithAlpha(
                CustomConfig.CommonSetting.navigationBarBackground, CustomConfig.CommonSetting.navigationBarAlpha));

        ivLoading = (AppCompatImageView) get("aihelp_iv_loading");
        ivTitle = (ImageView) get("aihelp_iv_title");
        tvTitle = (TextView) get("aihelp_tv_title");
        searchView = (AIHelpSearchView) get("aihelp_search_view");

        fakeSearchPort = (LinearLayout) get("aihelp_fake_search_port");
        fakeSearchPort.setBackgroundColor(Styles.getColorWithAlpha(
                CustomConfig.CommonSetting.navigationBarBackground, CustomConfig.CommonSetting.navigationBarAlpha));
        fakeSearchLand = (AIHelpFakeSearch) get("aihelp_fake_search_land");

        Styles.reRenderImageView(ivLoading, "aihelp_svg_ic_loading");

        BreakReleaseHelper releaseBreaker = new BreakReleaseHelper();
        tvTitle.setOnClickListener(releaseBreaker);
        tvTitle.setOnLongClickListener(releaseBreaker);
        tvTitle.setTextColor(Styles.getColor(CustomConfig.CommonSetting.textColor));
        tvTitle.setMaxWidth(Styles.getScreenWidth(tvTitle.getContext()) / 2);

        taskEntrance.setOnClickListener(this);
        fakeSearchPort.setOnClickListener(this);
        fakeSearchLand.setOnClickListener(this);

        updateTitleBarAccordingToSearchStatus(false);

        tvLogo = (TextView) get("aihelp_logo");
        tvLogo.setTextColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 1f));
        tvLogo.setBackgroundColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha));

        searchView.setupSearchView(new AIHelpSearchView.OnAIHelpSearchViewListener() {
            @Override
            public void onFocusChanged() {

            }

            @Override
            public void onInputCanceled() {
                FragmentManager childFragmentManager = getChildFragmentManager();
                if (childFragmentManager.getBackStackEntryCount() > 0) {
                    childFragmentManager.popBackStack();
                }
                updateTitleBarAccordingToSearchStatus(false);
            }

        }, getFaqEventListener());

        mSupportHelper.start();
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_support");
    }

    @Override
    protected boolean isBindEventBus() {
        return true;
    }

    @Override
    public void onEventComing(EventCenter event) {

        Fragment topMostFragment = FragmentHelper.getTopMostFragment(getRetainedChildFragmentManager());

        if (event instanceof LoadingElvaEvent) {
            if (event.getCode() == IntentValues.SHOW_CS_LOADING) {
                if (loadingAnimator.isRunning() || !shouldShowLoading(topMostFragment)) return;
                ivLoading.setVisibility(View.VISIBLE);
                loadingAnimator.start();
            } else {
                ivLoading.setVisibility(View.GONE);
                loadingAnimator.cancel();
            }
        }

        if (Const.TOGGLE_SHOW_TASK_ENTRANCE) {
            taskEntrance.setVisibility(topMostFragment instanceof FaqHomeFragment ?
                    View.VISIBLE : View.GONE);
        }

        if (event instanceof TaskCenterUnreadEvent) {
            taskEntrance.updateUnreadStatus(((TaskCenterUnreadEvent) event).getEvent());
        }

        if (event instanceof PageHoppingEvent) {
            switch (event.getCode()) {
                case IntentValues.PAGE_HOPPING_FORM:
                    mSupportHelper.onIntentToFillForm(((PageHoppingEvent) event).getEvent(), true);
                    break;
                case IntentValues.PAGE_HOPPING_TICKET_CONTENT:
                    mSupportHelper.onIntentToTicketContent(((PageHoppingEvent) event).getEvent());
                    break;
            }
        }

        if (event instanceof UpdateTitleEvent) {
            if (tvLogo != null) {
                boolean showBranding = !Const.TOGGLE_HIDE_BRAND && !(topMostFragment instanceof BaseCSFragment);
                tvLogo.setVisibility((showBranding ? View.VISIBLE : View.GONE));
            }
            UpdateTitleEvent updateTitleEvent = (UpdateTitleEvent) event;
            if (updateTitleEvent.getIcon() != null) {
                // 只有开关打开的前提下，才可以控制 icon 的显隐
                boolean showCsTitleIcon = topMostFragment instanceof BaseCSFragment && CustomConfig.CustomerService.isCsTitleIconVisible;
                boolean showFaqTitleIcon = topMostFragment instanceof BaseFaqFragment && CustomConfig.HelpCenter.isFaqTitleIconVisible;
                Styles.loadIcon(ivTitle, updateTitleEvent.getIcon(), showCsTitleIcon || showFaqTitleIcon);
            }
            if (updateTitleEvent.getTitle() != null) {
                tvTitle.setText(updateTitleEvent.getTitle());
            }
            updateFeedbackMaxWidth();
        }

        if (event instanceof SearchViewVisibilityChangeEvent) {
            boolean shouldShowSearchView = (boolean) event.getEvent();
            updateTitleBarAccordingToSearchStatus(shouldShowSearchView);
        }

        if (event instanceof OrientationChangeEvent) {
            tvTitle.setMaxWidth(Styles.getScreenWidth(tvTitle.getContext()) / 2);
            boolean isRealSearchVisibleNow = topMostFragment instanceof FaqSearchFragment;
            updateTitleBarAccordingToSearchStatus(isRealSearchVisibleNow);
            updateFeedbackMaxWidth();
        }

        if (event instanceof FatalErrorEvent && getActivity() != null && !getActivity().isFinishing()) {
            Toast.makeText(getActivity().getApplicationContext(), "Oops! Something went wrong", Toast.LENGTH_SHORT).show();

            AIHelpMqtt.getInstance().onFaqDestroy();
            AIHelpMqtt.getInstance().disconnect();
            Const.IS_SDK_SHOWING = false;

            ActivityManager.INSTANCE.finishAll();
        }

    }

    private boolean shouldShowLoading(Fragment topFragment) {
        if (topFragment != null) {
            String topName = topFragment.getClass().getSimpleName();
            return CustomerServiceFragment.class.getSimpleName().equals(topName);
        }
        return false;
    }

    public boolean onBackPressed() {
        Fragment topMostFragment = FragmentHelper.getTopMostFragment(getRetainedChildFragmentManager());
//        if (topMostFragment == null) return false;
        if (topMostFragment == null) return true;
        String topName = topMostFragment.getClass().getSimpleName();
        if (FaqContentFragment.class.getSimpleName().equals(topName)) {
            return ((FaqContentFragment) (topMostFragment)).onBackPressed();
        } else if (IntentUrlFragment.class.getSimpleName().equals(topName)) {
            return ((IntentUrlFragment) (topMostFragment)).onBackPressed();
        } else if (FaqSearchFragment.class.getSimpleName().equals(topName)) {
            SoftInputUtil.hideSoftInput(getContext(), searchView);
        }
        return true;
    }

    @Override
    public void onClick(View v) {

        if (FastClickValidator.validate(0.5f) && Const.isNestedFragmentOnResume) {
            if (v.getId() == ResResolver.getViewId("aihelp_iv_back")) {
                if (getActivity() != null) getActivity().onBackPressed();
            }

            if (v.getId() == ResResolver.getViewId("aihelp_fake_search_port") ||
                    v.getId() == ResResolver.getViewId("aihelp_fake_search_land")) {
                mSupportHelper.onIntentToSearch(getArguments());
                searchView.autoFocus();
                StatisticTracker.getInstance().clickSearch();
            }

            if (v.getId() == ResResolver.getViewId("aihelp_feedback_entrance")) {
                mSupportHelper.onIntentToTicketList(getArguments());
                taskEntrance.updateUnreadStatus(false);
            }
        }

    }

    private void updateTitleBarAccordingToSearchStatus(boolean showRealSearch) {

        ViewGroup viewGroup = (ViewGroup) ivTitle.getParent();
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) viewGroup.getLayoutParams();

        Fragment topFragment = FragmentHelper.getTopMostFragment(getRetainedChildFragmentManager());
        if (topFragment instanceof BaseFaqFragment) {
            // icon 开关优先级最高，开关打开再根据 searchStatus 来控制 icon 的显隐
            ivTitle.setVisibility(CustomConfig.HelpCenter.isFaqTitleIconVisible && !showRealSearch ? View.VISIBLE : View.GONE);
            tvTitle.setVisibility(!showRealSearch ? View.VISIBLE : View.GONE);

            if (CustomConfig.HelpCenter.isFaqSearchVisible) {
                boolean isFaqHome = FaqHomeFragment.class.getName().equals(topFragment.getClass().getName());
                fakeSearchPort.setVisibility(isFaqHome && !Styles.isLandscape() && !showRealSearch ? View.VISIBLE : View.GONE);
                fakeSearchLand.setVisibility(isFaqHome && Styles.isLandscape() && !showRealSearch ? View.VISIBLE : View.GONE);
                searchView.setVisibility(showRealSearch ? View.VISIBLE : View.GONE);
            }

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                layoutParams.addRule(RelativeLayout.END_OF, ResResolver.getViewId("aihelp_iv_back"));
                layoutParams.addRule(RelativeLayout.RIGHT_OF, ResResolver.getViewId("aihelp_iv_back"));
                viewGroup.setLayoutParams(layoutParams);
            }
        }

        if (topFragment instanceof BaseCSFragment || topFragment instanceof TaskListFragment) {
            // 只有在开启了开关的前提下，才可以控制标题栏 icon 的显示
            ivTitle.setVisibility(CustomConfig.CustomerService.isCsTitleIconVisible ? View.VISIBLE : View.GONE);
            tvTitle.setVisibility(View.VISIBLE);
            fakeSearchPort.setVisibility(View.GONE);
            fakeSearchLand.setVisibility(View.GONE);
            searchView.setVisibility(View.GONE);

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                layoutParams.removeRule(RelativeLayout.RIGHT_OF);
                layoutParams.removeRule(RelativeLayout.END_OF);
                viewGroup.setLayoutParams(layoutParams);
            }
        }

        if (topFragment instanceof TaskDetailFragment) {
            tvLogo.setVisibility(View.GONE);
        }
    }

    private void updateFeedbackMaxWidth() {
        tvTitle.measure(0, 0);
        int minTitleWidth = Styles.dpToPx(getContext(), 100);
        tvTitle.post(new Runnable() {
            @Override
            public void run() {
                Rect rect = new Rect();
                tvTitle.getGlobalVisibleRect(rect);
                fakeSearchLand.update(taskEntrance.getVisibility() == View.VISIBLE);
                taskEntrance.updateMaxWidth(Math.max(minTitleWidth, Styles.isLayoutRtl(taskEntrance) ? rect.left : rect.right));
            }
        });
    }

    protected int getLoadingTargetViewId() {
        return ResResolver.getViewId("aihelp_support_fragment_container");
    }

    @Override
    public IFaqEventListener getFaqEventListener() {
        return mSupportHelper;
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (loadingAnimator != null) {
            loadingAnimator.cancel();
            loadingAnimator = null;
        }
        AIHelpMqtt.getInstance().onFaqDestroy();
    }
}
