package net.aihelp.ui.adapter;

import android.content.Context;

import net.aihelp.core.ui.adapter.MultiItemTypeAdapter;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.track.statistic.StatisticTracker;
import net.aihelp.ui.adapter.cs.agent.AgentAnswerAdapter;
import net.aihelp.ui.adapter.cs.agent.AgentFileAdapter;
import net.aihelp.ui.adapter.cs.agent.AgentRichTextAdapter;
import net.aihelp.ui.adapter.cs.agent.AgentVideoAdapter;
import net.aihelp.ui.adapter.cs.other.ErrorBoundaryAdapter;
import net.aihelp.ui.adapter.cs.other.LoadingAdapter;
import net.aihelp.ui.adapter.cs.other.TimeMsgAdapter;
import net.aihelp.ui.adapter.cs.agent.AgentFaqAdapter;
import net.aihelp.ui.adapter.cs.agent.AgentImageAdapter;
import net.aihelp.ui.adapter.cs.agent.AgentTextAdapter;
import net.aihelp.ui.adapter.cs.user.UserEvaluateFaqAdapter;
import net.aihelp.ui.adapter.cs.user.UserFileAdapter;
import net.aihelp.ui.adapter.cs.user.UserImageAdapter;
import net.aihelp.ui.adapter.cs.user.UserTextAdapter;
import net.aihelp.ui.adapter.cs.user.UserVideoAdapter;
import net.aihelp.utils.ListUtil;

import java.util.Iterator;
import java.util.List;

import androidx.fragment.app.Fragment;


public class MessageListAdapter extends MultiItemTypeAdapter<Message> {

    private StringBuilder timestampTracker;

    private final AgentTextAdapter adminAdapter;
    private final AgentFaqAdapter agentFaqAdapter;
    private final AgentAnswerAdapter answerFaqAdapter;
    private final AgentRichTextAdapter agentRichTextAdapter;

    private final UserTextAdapter userAdapter;
    private final UserImageAdapter userImageAdapter;
    private final UserVideoAdapter userVideoAdapter;
    private final UserFileAdapter userFileAdapter;

    public MessageListAdapter(Context context, Fragment fragment) {
        super(context);

        // All message's timestamp
        timestampTracker = new StringBuilder();

        // Agent
        adminAdapter = new AgentTextAdapter(context);
        addItemViewDelegate(adminAdapter);
        agentRichTextAdapter = new AgentRichTextAdapter(context, fragment);
        addItemViewDelegate(agentRichTextAdapter);
        agentFaqAdapter = new AgentFaqAdapter(context);
        addItemViewDelegate(agentFaqAdapter);
        answerFaqAdapter = new AgentAnswerAdapter(context);
        addItemViewDelegate(answerFaqAdapter);
        addItemViewDelegate(new AgentImageAdapter(context, fragment));
        addItemViewDelegate(new AgentVideoAdapter(context, fragment));
        addItemViewDelegate(new AgentFileAdapter(context, fragment));

        // User
        userAdapter = new UserTextAdapter(context);
        addItemViewDelegate(userAdapter);
        userImageAdapter = new UserImageAdapter(context, fragment);
        addItemViewDelegate(userImageAdapter);
        userVideoAdapter = new UserVideoAdapter(context, fragment);
        addItemViewDelegate(userVideoAdapter);
        addItemViewDelegate(new UserEvaluateFaqAdapter(context));
        userFileAdapter = new UserFileAdapter(context, fragment);
        addItemViewDelegate(userFileAdapter);

        // Hints
        addItemViewDelegate(new TimeMsgAdapter(context));
        addItemViewDelegate(new LoadingAdapter(context));

        // ErrorBoundary
        addItemViewDelegate(-1, new ErrorBoundaryAdapter(context));

    }

    public void insertHistoryConversation(List<Message> msgList) {
        mDatas.addAll(0, msgList);
        notifyDataSetChanged();
    }

    public void updateAgentTypingStatus(boolean visible) {
        if (visible) {
            update(Message.getAgentTypingMsg());
        } else {
            for (int i = getItemCount() - 1; i >= 0; i--) {
                Message msg = mDatas.get(i);
                if (msg.getMsgType() == Message.TYPE_LOADING) {
                    StatisticTracker.getInstance().calculateDurationForWaiting();
                    remove(i);
                    break;
                }
            }
        }
    }

    @Override
    public void update(Message message) {
        if (isMessageAlreadyInserted(message)) return;
        super.update(message);
    }

    @Override
    public void update(List<Message> dataList, Boolean isClear) {
        if (ListUtil.isListEmpty(dataList)) return;
        if (isClear) timestampTracker = new StringBuilder();
        Iterator<Message> iterator = dataList.iterator();
        while (iterator.hasNext()) {
            Message message = iterator.next();
            if (isMessageAlreadyInserted(message)) {
                iterator.remove();
            }
        }
        super.update(dataList, isClear);
    }

    private boolean isMessageAlreadyInserted(Message message) {
        if (timestampTracker == null) timestampTracker = new StringBuilder();
        String timestamp = String.valueOf(message.getTimestamp());
        if (timestampTracker.toString().contains(timestamp)) {
            return true;
        }
        timestampTracker.append(String.format("%s,", timestamp));
        return false;
    }


    private interface OnTextClickedListener {

        void onUrlClicked(boolean isForm, String url);

        void onBotAnswerSelected(Message message);

        void onRetrySendingMessage(int position, Message message);

    }

    public void setOnClickedListener(OnClickedListenerWrapper mListener) {
        if (adminAdapter != null) {
            adminAdapter.setOnClickedListenerWrapper(mListener);
        }

        if (agentRichTextAdapter != null) {
            agentRichTextAdapter.setOnClickedListenerWrapper(mListener);
        }

        if (agentFaqAdapter != null) {
            agentFaqAdapter.setOnClickedListenerWrapper(mListener);
        }

        if (answerFaqAdapter != null) {
            answerFaqAdapter.setOnClickedListenerWrapper(mListener);
        }

        if (userAdapter != null) {
            userAdapter.setOnClickedListenerWrapper(mListener);
        }

        if (userImageAdapter != null) {
            userImageAdapter.setOnClickedListenerWrapper(mListener);
        }

        if (userVideoAdapter != null) {
            userVideoAdapter.setOnClickedListenerWrapper(mListener);
        }

        if (userFileAdapter != null) {
            userFileAdapter.setOnClickedListenerWrapper(mListener);
        }

    }

    public static class OnClickedListenerWrapper implements OnTextClickedListener {

        @Override
        public void onUrlClicked(boolean isForm, String url) {
            if (isForm) {
                StatisticTracker.getInstance().onFormClicked(url);
            }
        }

        @Override
        public void onBotAnswerSelected(Message message) {

        }

        @Override
        public void onRetrySendingMessage(int position, Message msg) {

        }

    }


}
