package net.aihelp.ui.adapter.cs.agent;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.rpa.msg.base.FileMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.preview.PreviewActivity;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.ui.widget.AIHelpLoadingImageView;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import androidx.fragment.app.Fragment;

public class AgentImageAdapter extends BaseMsgAdapter {

    private Fragment fragment;

    public AgentImageAdapter(Context context, Fragment fragment) {
        super(context);
        this.fragment = fragment;
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_agent_image");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == Message.TYPE_AGENT_IMAGE;
    }

    @Override
    public void convert(ViewHolder holder, final Message message, final int position) {

        if (message instanceof FileMessage) {

            FileMessage fileMessage = (FileMessage) message;

            Styles.loadIcon(holder.getView(getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csManualSupportPortrait,
                    CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_agent");

            Styles.reRenderTextView(holder.getView(getViewId("aihelp_tv_nickname")),
                    fileMessage.getNickname(),
                    Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8),
                    CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty(fileMessage.getNickname()),
                    13);

            final AIHelpLoadingImageView imageView = holder.getView(getViewId("aihelp_iv_holder"));
            imageView.loadIntoImageView(mContext, fileMessage);

            imageView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (imageView.isLoading()) return;
                    PreviewActivity.startAct(fragment, PreviewInfo.get(fileMessage.getContent()));

                }
            });
        }

    }

}
