package net.aihelp.ui.adapter.cs.agent;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.model.rpa.msg.base.FileMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.preview.PreviewActivity;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.ui.widget.AIHelpLoadingImageView;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.TLog;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import androidx.fragment.app.Fragment;

public class AgentVideoAdapter extends BaseMsgAdapter {

    private final ExecutorService mExecutorService;

    public AgentVideoAdapter(Context context, Fragment fragment) {
        super(context, fragment);
        mExecutorService = Executors.newCachedThreadPool();
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_agent_video");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == Message.TYPE_AGENT_VIDEO;
    }

    @Override
    public void convert(final ViewHolder holder, final Message message, final int position) {

        if (message instanceof FileMessage) {
            FileMessage fileMessage = (FileMessage) message;

            Styles.loadIcon(holder.getView(getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csManualSupportPortrait,
                    CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_agent");

            Styles.reRenderTextView(holder.getView(getViewId("aihelp_tv_nickname")),
                    fileMessage.getNickname(),
                    Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8),
                    CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty(fileMessage.getNickname()),
                    13);

            if (fileMessage.getVideoThumbnail() != null) {
                loadUpImageView(holder, fileMessage, position);
            } else {
                if (mExecutorService != null) mExecutorService.execute(new Runnable() {
                    @Override
                    public void run() {
                        fileMessage.prepareVideoThumbnail();

                        // java.lang.IllegalArgumentException: You cannot start a load for a destroyed activity
                        if (mContext instanceof Activity && ((Activity) mContext).isFinishing()) {
                            TLog.d("You cannot start a load for a destroyed activity, interrupt current invoke.");
                            return;
                        }

                        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                loadUpImageView(holder, fileMessage, position);
                            }
                        });
                    }
                });
            }
        }

    }

    private void loadUpImageView(ViewHolder holder, final FileMessage fileMessage, final int position) {
        final AIHelpLoadingImageView imageView = holder.getView(getViewId("aihelp_iv_holder"));
        imageView.loadIntoImageView(mContext, fileMessage);

        imageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (imageView.isLoading()) return;
//                ImageViewer.getDefault(mContext).updateVideoResource(mediaMessage.getVideoThumbnail(), mediaMessage.getContent()).show();
//                Previewer.getDefault(mContext)
//                        .updateFilePath(mediaMessage.getContent())
//                        .show();
                PreviewActivity.startAct(mFragment, PreviewInfo.get(fileMessage.getContent()));
            }
        });
    }

}
