package net.aihelp.ui.adapter.cs.other;

import android.content.Context;
import android.widget.LinearLayout;
import android.widget.TextView;

import net.aihelp.BuildConfig;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.utils.DateFormatUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class ErrorBoundaryAdapter extends BaseMsgAdapter {

    public ErrorBoundaryAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_error_boundary");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return false;
    }

    @Override
    public void convert(ViewHolder holder, Message message, int position) {
        if (BuildConfig.DEBUG) {
            TextView tvError = (TextView) holder.getConvertView();
            Styles.reRenderTextView(tvError, "Something is missing here");
        }
    }

}
