package net.aihelp.ui.adapter.cs.other;

import android.content.Context;
import android.view.View;
import android.widget.LinearLayout;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class LoadingAdapter extends BaseMsgAdapter {

    public LoadingAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_typing");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == Message.TYPE_LOADING;
    }

    @Override
    public void convert(ViewHolder holder, Message message, int position) {
        View ivPortrait = holder.getView(getViewId("aihelp_iv_portrait"));
        ivPortrait.setVisibility(CustomConfig.CustomerService.isPortraitVisible ? View.INVISIBLE : View.GONE);

        LinearLayout llContainer = holder.getView(getViewId("aihelp_typing_container"));
        llContainer.setBackground(getAdminBackgroundDrawable(isCurrentRtl));
    }

}
