package net.aihelp.ui.adapter.cs.user;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import androidx.appcompat.widget.AppCompatImageButton;

public class UserEvaluateFaqAdapter extends BaseMsgAdapter {

    public UserEvaluateFaqAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_user_evaluate_faq");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == Message.TYPE_USER_EVALUATE_FAQ;
    }

    @Override
    public void convert(final ViewHolder holder, final Message message, final int position) {

        // 头像
        Styles.loadIcon(holder.getView(getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csUserPortrait,
                CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_user");

        // 点踩
        ImageView ivUnHelpful = holder.getView(getViewId("aihelp_iv_un_helpful"));
        Styles.reRenderImageView(ivUnHelpful, "aihelp_svg_ic_un_helpful");
        ivUnHelpful.setVisibility(":aihelp-faq-unhelpful:".equals(message.getContent()) ? View.VISIBLE : View.GONE);

        // 点赞
        ImageView ivHelpful = holder.getView(getViewId("aihelp_iv_helpful"));
        Styles.reRenderImageView(ivHelpful, "aihelp_svg_ic_helpful");
        ivHelpful.setVisibility(":aihelp-faq-helpful:".equals(message.getContent()) ? View.VISIBLE : View.GONE);

        // 失败后重试
        AppCompatImageButton retryButton = holder.getView(getViewId("aihelp_iv_msg_retry"));
        switch (message.getMsgStatus()) {
            case Message.STATUS_NORMAL:
            case Message.STATUS_SENDING:
                retryButton.setVisibility(View.GONE);
                break;
            case Message.STATUS_FAILURE:
                retryButton.setVisibility(View.VISIBLE);
                retryButton.setImageResource(ResResolver.getDrawableId("aihelp_svg_iv_msg_retry"));
                retryButton.setOnClickListener(getRetryListener(position, message));
                break;
        }

    }

}
