package net.aihelp.ui.adapter.cs.user;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.core.ui.loading.indicator.LoadingIndicatorView;
import net.aihelp.data.model.rpa.msg.base.FileMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.preview.PreviewActivity;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import androidx.appcompat.widget.AppCompatImageButton;
import androidx.fragment.app.Fragment;

public class UserFileAdapter extends BaseMsgAdapter {

    public UserFileAdapter(Context context, Fragment fragment) {
        super(context, fragment);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_user_file");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == Message.TYPE_USER_FILE;
    }

    @Override
    public void convert(final ViewHolder holder, final Message message, final int position) {
        if (message instanceof FileMessage) {
            FileMessage fileMessage = (FileMessage) message;

            Styles.loadIcon(holder.getView(getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csUserPortrait,
                    CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_user");

            RelativeLayout rlContainer = holder.getView(ResResolver.getViewId("aihelp_rl_file_container"));
            rlContainer.setBackground(getUserBackgroundDrawable(isCurrentRtl));

            rlContainer.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (fileMessage.getMsgStatus() == Message.STATUS_NORMAL) {
                        PreviewInfo previewInfo = PreviewInfo.get(fileMessage.getContent(), fileMessage.getFileName());
                        PreviewActivity.startAct(mFragment, previewInfo);
                    }
                }
            });

            TextView tvFileName = holder.getView(getViewId("aihelp_tv_file_name"));
            tvFileName.setMaxWidth(getRightfulMaxWidthForFileName());
            Styles.reRenderTextView(tvFileName, fileMessage.getFileName(),
                    Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8), true, 14);

            Styles.reRenderTextView(holder.getView(getViewId("aihelp_tv_file_size")),
                    fileMessage.getFileSize(),
                    Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8), true, 14);

            Styles.reRenderImageView(holder.getView(getViewId("aihelp_iv_file")),
                    "aihelp_svg_ic_file",
                    Styles.getColor(CustomConfig.CommonSetting.highlightedColor));

            Styles.reRenderImageView(holder.getView(getViewId("aihelp_iv_download")),
                    "aihelp_svg_ic_download",
                    Styles.getColor(CustomConfig.CommonSetting.highlightedColor));
            holder.getView(ResResolver.getViewId("aihelp_iv_download")).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    AppInfoUtil.openWithBrowser(mContext, fileMessage.getContent());
                }
            });

            LoadingIndicatorView loadingView = holder.getView(getViewId("aihelp_iv_msg_sending"));
            loadingView.setIndicatorColor(Styles.getColor(CustomConfig.CommonSetting.textColor));
            AppCompatImageButton retryButton = holder.getView(getViewId("aihelp_iv_msg_retry"));
            switch (message.getMsgStatus()) {
                case Message.STATUS_NORMAL:
                    loadingView.setVisibility(View.GONE);
                    retryButton.setVisibility(View.GONE);
                    break;
                case Message.STATUS_SENDING:
                    loadingView.setVisibility(View.VISIBLE);
                    retryButton.setVisibility(View.GONE);
                    break;
                case Message.STATUS_FAILURE:
                    loadingView.setVisibility(View.GONE);
                    retryButton.setVisibility(View.VISIBLE);
                    retryButton.setImageResource(ResResolver.getDrawableId("aihelp_svg_iv_msg_retry"));
                    retryButton.setOnClickListener(getFileRetryListener(position, message));
                    break;
            }
        }
    }

    private int getRightfulMaxWidthForFileName() {
        return Styles.getScreenWidth(mContext)
                - dip2px(mContext, 60) // left margin of whole layout offset the screen
                - dip2px(mContext, 36) // file icon width
                - dip2px(mContext, 20) // file icon and download icon's right margin
                - dip2px(mContext, 23) // download icon width
                - dip2px(mContext, 20) // message container left and right padding
                - dip2px(mContext, 20) // portrait leading and trailing margin
                - dip2px(mContext, 39);// portrait
    }

    private Drawable getUserBackgroundDrawable(boolean isRtl) {
        int colorFromHex = Color.parseColor(CustomConfig.CommonSetting.interactElementTextColor);
        return isRtl ? Styles.getDrawableWithCorner(colorFromHex, 0, 15, 15, 15)
                : Styles.getDrawableWithCorner(colorFromHex, 15, 0, 15, 15);
    }

}
