package net.aihelp.ui.adapter.task.detail;

import android.content.Context;
import android.util.TypedValue;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.task.ReplyMessage;
import net.aihelp.ui.widget.AIHelpRatingBar;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.RichTextSlicer;
import net.aihelp.utils.Styles;

import androidx.fragment.app.Fragment;


public class ReplyEvaluationAdapter extends BaseReplyAdapter {

    public ReplyEvaluationAdapter(Context context, Fragment fragment) {
        super(context, fragment);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_task_reply_evaluation");
    }

    @Override
    public boolean isForViewType(ReplyMessage item, int position) {
        return item.getMsgType() == ReplyMessage.MSG_TYPE_EVALUATION;
    }

    @Override
    public void convert(ViewHolder holder, ReplyMessage replyMessage, int position) {
        super.convert(holder, replyMessage, position);
        AIHelpRatingBar ratingBar = holder.getView(ResResolver.getViewId("aihelp_rating_bar"));
        ratingBar.setCurrGrade(replyMessage.getStar());

        TextView tvEvaluation = holder.getView(ResResolver.getViewId("aihelp_tv_evaluation"));
        Styles.reRenderTextView(tvEvaluation, replyMessage.getContent());
    }

}
