package net.aihelp.ui.adapter.task.detail;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.core.ui.loading.indicator.LoadingIndicatorView;
import net.aihelp.data.model.rpa.msg.base.FileMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.task.ReplyMessage;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.preview.PreviewActivity;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import androidx.appcompat.widget.AppCompatImageButton;
import androidx.fragment.app.Fragment;

public class ReplyFileAdapter extends BaseReplyAdapter {

    public ReplyFileAdapter(Context context, Fragment fragment) {
        super(context, fragment);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_task_reply_file");
    }

    @Override
    public boolean isForViewType(ReplyMessage message, int position) {
        return message.getMsgType() == ReplyMessage.MSG_TYPE_FILE;
    }

    @Override
    public void convert(ViewHolder holder, final ReplyMessage message, final int position) {
        super.convert(holder, message, position);

        RelativeLayout rlContainer = holder.getView(getViewId("aihelp_rl_file_container"));
        rlContainer.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                PreviewInfo previewInfo = PreviewInfo.get(message.getContent(), message.getFileName());
                PreviewActivity.startAct(mFragment, previewInfo);
            }
        });

        TextView tvFileName = holder.getView(getViewId("aihelp_tv_file_name"));
        tvFileName.setMaxWidth(getRightfulMaxWidthForFileName());
        Styles.reRenderTextView(tvFileName, message.getFileName(),
                Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8), true, 14);

        Styles.reRenderTextView(holder.getView(getViewId("aihelp_tv_file_size")),
                message.getFileSize(),
                Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8), true, 14);

        Styles.reRenderImageView(holder.getView(getViewId("aihelp_iv_file")),
                "aihelp_svg_ic_file",
                Styles.getColor(CustomConfig.CommonSetting.highlightedColor));

        Styles.reRenderImageView(holder.getView(getViewId("aihelp_iv_download")),
                "aihelp_svg_ic_download",
                Styles.getColor(CustomConfig.CommonSetting.highlightedColor));
        holder.getView(ResResolver.getViewId("aihelp_iv_download")).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                AppInfoUtil.openWithBrowser(mContext, message.getContent());
            }
        });

        LoadingIndicatorView loadingView = holder.getView(getViewId("aihelp_iv_msg_sending"));
        loadingView.setIndicatorColor(Styles.getColor(CustomConfig.CommonSetting.textColor));
        AppCompatImageButton retryButton = holder.getView(getViewId("aihelp_iv_msg_retry"));
        switch (message.getMsgStatus()) {
            case ReplyMessage.STATUS_NORMAL:
                loadingView.setVisibility(View.GONE);
                retryButton.setVisibility(View.GONE);
                break;
            case ReplyMessage.STATUS_SENDING:
                loadingView.setVisibility(View.VISIBLE);
                retryButton.setVisibility(View.GONE);
                break;
            case ReplyMessage.STATUS_FAILURE:
                loadingView.setVisibility(View.GONE);
                retryButton.setVisibility(View.VISIBLE);
                retryButton.setImageResource(ResResolver.getDrawableId("aihelp_svg_iv_msg_retry"));
                break;
        }

    }

    private int getRightfulMaxWidthForFileName() {
        return Styles.getScreenWidth(mContext)
                - Styles.dpToPx(mContext, 39) // portrait
                - Styles.dpToPx(mContext, 20) // portrait leading and trailing margin
                - Styles.dpToPx(mContext, 20) // message container left and right padding
                - Styles.dpToPx(mContext, 36) // file icon width
                - Styles.dpToPx(mContext, 20) // file icon and download icon's right margin
                - Styles.dpToPx(mContext, 23) // download icon width
                - Styles.dpToPx(mContext, 60);// right margin of whole layout offset the screen
    }

}
