package net.aihelp.ui.adapter.task.detail;

import android.content.Context;
import android.view.View;

import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.task.ReplyMessage;
import net.aihelp.ui.widget.AIHelpLoadingImageView;
import net.aihelp.utils.ResResolver;

import androidx.fragment.app.Fragment;


public class ReplyImageAdapter extends BaseReplyAdapter {

    public ReplyImageAdapter(Context context, Fragment fragment) {
        super(context, fragment);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_task_reply_image");
    }

    @Override
    public boolean isForViewType(ReplyMessage item, int position) {
        return item.getMsgType() == ReplyMessage.MSG_TYPE_IMAGE;
    }

    @Override
    public void convert(ViewHolder holder, ReplyMessage replyMessage, int position) {
        super.convert(holder, replyMessage, position);

        View ivRetry = holder.getView(ResResolver.getViewId("aihelp_iv_msg_retry"));
        ivRetry.setVisibility(replyMessage.getMsgStatus() == ReplyMessage.STATUS_FAILURE ? View.VISIBLE : View.GONE);
        ivRetry.setOnClickListener(getRetryHandler(position, replyMessage));

        if (replyMessage.getMsgStatus() == ReplyMessage.STATUS_SENDING) {
            AIHelpLoadingImageView imageView = holder.getView(ResResolver.getViewId("aihelp_iv_holder"));
            imageView.resetStatus();
            return;
        }

        loadUpImageView(holder, replyMessage);

//        ImageView ivTest = holder.getView(ResResolver.getViewId("aihelp_iv_test"));
//        Picasso.get().load("https://local.aihelp.net/resource/FileService/SysFile/Faq/202307/20230714074409663668fa80edf.jpg").fit().into(ivTest);

    }

}
