package net.aihelp.ui.adapter.task.detail;

import android.content.Context;
import android.widget.LinearLayout;

import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.task.ReplyMessage;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.RichTextSlicer;

import androidx.fragment.app.Fragment;


public class ReplyTextAdapter extends BaseReplyAdapter {

    public ReplyTextAdapter(Context context, Fragment fragment) {
        super(context, fragment);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_task_reply_container");
    }

    @Override
    public boolean isForViewType(ReplyMessage item, int position) {
        return item.getMsgType() == ReplyMessage.MSG_TYPE_TEXT;
    }

    @Override
    public void convert(ViewHolder holder, ReplyMessage replyMessage, int position) {
        super.convert(holder, replyMessage, position);
        LinearLayout llContent = holder.getView(ResResolver.getViewId("aihelp_ll_content"));
        llContent.removeAllViews();
        llContent.addView(RichTextSlicer.getRichTextView(mContext, mFragment, replyMessage.getContent()));
    }

}
