package net.aihelp.ui.adapter.task.detail;

import android.app.Activity;
import android.content.Context;

import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.model.task.ReplyMessage;
import net.aihelp.ui.widget.AIHelpLoadingImageView;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.TLog;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import androidx.fragment.app.Fragment;


public class ReplyVideoAdapter extends BaseReplyAdapter {

    private final ExecutorService mExecutorService;

    public ReplyVideoAdapter(Context context, Fragment fragment) {
        super(context, fragment);
        mExecutorService = Executors.newCachedThreadPool();
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_task_reply_video");
    }

    @Override
    public boolean isForViewType(ReplyMessage item, int position) {
        return item.getMsgType() == ReplyMessage.MSG_TYPE_VIDEO;
    }

    @Override
    public void convert(ViewHolder holder, ReplyMessage replyMessage, int position) {
        super.convert(holder, replyMessage, position);

        if (replyMessage.getMsgStatus() == ReplyMessage.STATUS_SENDING) {
            AIHelpLoadingImageView imageView = holder.getView(ResResolver.getViewId("aihelp_iv_holder"));
            imageView.resetStatus();
            return;
        }

        if (replyMessage.getVideoThumbnail() != null) {
            loadUpImageView(holder, replyMessage);
        } else {
            if (mExecutorService != null) mExecutorService.execute(new Runnable() {
                @Override
                public void run() {
                    replyMessage.prepareVideoThumbnail();

                    // java.lang.IllegalArgumentException: You cannot start a load for a destroyed activity
                    if (mContext instanceof Activity && ((Activity) mContext).isFinishing()) {
                        TLog.d("You cannot start a load for a destroyed activity, interrupt current invoke.");
                        return;
                    }

                    ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            loadUpImageView(holder, replyMessage);
                        }
                    });
                }
            });
        }
    }

}
