package net.aihelp.ui.adapter.task.detail;

import android.content.Context;

import net.aihelp.core.ui.adapter.MultiItemTypeAdapter;
import net.aihelp.data.model.task.ReplyMessage;

import androidx.fragment.app.Fragment;

public class TaskReplyListAdapter extends MultiItemTypeAdapter<ReplyMessage> {

    private final ReplyImageAdapter replyImageAdapter;
    private final ReplyVideoAdapter replyVideoAdapter;

    public TaskReplyListAdapter(Context context, Fragment fragment) {
        super(context);

        addItemViewDelegate(new ReplyTextAdapter(context, fragment));

        replyImageAdapter = new ReplyImageAdapter(context, fragment);
        addItemViewDelegate(replyImageAdapter);

        replyVideoAdapter = new ReplyVideoAdapter(context, fragment);
        addItemViewDelegate(replyVideoAdapter);
        addItemViewDelegate(new ReplyFileAdapter(context, fragment));
        addItemViewDelegate(new ReplyEvaluationAdapter(context, fragment));
    }

    public void setOnReplyEventListener(OnReplyEventListener eventListener) {
        if (replyImageAdapter != null) {
            replyImageAdapter.setOnReplyEventListener(eventListener);
        }
        if (replyVideoAdapter != null) {
            replyVideoAdapter.setOnReplyEventListener(eventListener);
        }
    }

    public interface OnReplyEventListener {
        void onRetrySendingMessage(int position, ReplyMessage message);
    }

}
