package net.aihelp.ui.adapter.task.widget;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;

public class EvaluateTicketView extends FrameLayout implements View.OnClickListener {

    private int negativeCount = 0;
    private int positiveCount = 0;
    private OnAIHelpEvaluateViewListener listener;

    public void setOnAIHelpEvaluateViewListener(OnAIHelpEvaluateViewListener listener) {
        this.listener = listener;
    }

    public EvaluateTicketView(@NonNull Context context) {
        this(context, null);
    }

    public EvaluateTicketView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EvaluateTicketView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        // 加载 xml 布局
        View rootView = View.inflate(context, ResResolver.getLayoutId("aihelp_evaluate_ticket_view"), this);
        int colorFromHex = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor,
                CustomConfig.CommonSetting.upperBackgroundAlpha);
        rootView.setBackground(Styles.getDrawable(colorFromHex, 0));

        // 点踩视图
        AppCompatImageView unhelpfulView = rootView.findViewById(ResResolver.getViewId("aihelp_iv_un_helpful"));
        Styles.reRenderImageView(unhelpfulView, "aihelp_svg_ic_un_helpful", Color.parseColor("#ff4747"));
        TextView tvUnhelpfulCount = rootView.findViewById(ResResolver.getViewId("aihelp_tv_unhelpful_count"));
        Styles.reRenderTextView(tvUnhelpfulCount, "", Color.parseColor("#ff4747"));

        // 点赞视图
        AppCompatImageView helpfulView = rootView.findViewById(ResResolver.getViewId("aihelp_iv_helpful"));
        Styles.reRenderImageView(helpfulView, "aihelp_svg_ic_helpful", true);
        TextView tvHelpfulCount = rootView.findViewById(ResResolver.getViewId("aihelp_tv_helpful_count"));
        Styles.reRenderTextView(tvHelpfulCount, "", Styles.getColor(CustomConfig.CommonSetting.interactElementTextColor));

        // 给点赞、点踩和提建议设置点击事件
        unhelpfulView.setOnClickListener(this);
        helpfulView.setOnClickListener(this);

    }

    public void setupView(boolean violateSLA, int negativeCount, int positiveCount) {
        if (violateSLA) {
            findViewById(ResResolver.getViewId("aihelp_ll_unhelpful")).setVisibility(VISIBLE);
            findViewById(ResResolver.getViewId("aihelp_v_anchor")).setVisibility(VISIBLE);
        }
        if (negativeCount > 0) {
            this.negativeCount = negativeCount;
            TextView unhelpfulCount = findViewById(ResResolver.getViewId("aihelp_tv_unhelpful_count"));
            unhelpfulCount.setText(String.format("+%s", negativeCount));
        }
        if (positiveCount > 0) {
            this.positiveCount = positiveCount;
            TextView helpfulCount = findViewById(ResResolver.getViewId("aihelp_tv_helpful_count"));
            helpfulCount.setText(String.format("+%s", positiveCount));
        }
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == ResResolver.getViewId("aihelp_iv_un_helpful")) {
            animateFloatingText(v, false);
            if (listener != null) {
                listener.onEvaluated(false, negativeCount);
            }
        }

        if (v.getId() == ResResolver.getViewId("aihelp_iv_helpful")) {
            animateFloatingText(v, true);
            if (listener != null) {
                listener.onEvaluated(true, positiveCount);
            }
        }
    }

    private void animateFloatingText(View view, boolean helpful) {
        ImageView imageView = new ImageView(getContext());
        if (helpful) {
            Styles.reRenderImageView(imageView, "aihelp_svg_ic_laugh");
        } else {
            Styles.reRenderImageView(imageView, "aihelp_svg_ic_angry", Color.parseColor("#ff4747"));
        }

        TextView countView;
        if (helpful) {
            countView = findViewById(ResResolver.getViewId("aihelp_tv_helpful_count"));
            countView.setText(String.format("+%s", ++positiveCount));
        } else {
            countView = findViewById(ResResolver.getViewId("aihelp_tv_unhelpful_count"));
            countView.setText(String.format("+%s", ++negativeCount));
        }
        ViewAnimator.getInstance().start(view, countView, imageView);
    }

    public interface OnAIHelpEvaluateViewListener {
        void onEvaluated(boolean isHelpful, int count);
    }

}
