package net.aihelp.ui.adapter.task.widget;

import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

public class ViewAnimator {

    public static final ViewAnimator INSTANCE = new ViewAnimator();

    private ViewAnimator() {
    }

    public static ViewAnimator getInstance() {
        return INSTANCE;
    }

    private int mX;
    private int mY;

    public void start(View targetView, View countView, View animView) {
        getLocation(targetView);
        addAnimView(targetView, countView, animView);
        startAnim(animView);
    }

    public void getLocation(View view) {
        Rect rect = new Rect();
        view.getGlobalVisibleRect(rect);
        mX = rect.left;
        mY = rect.top;
    }

    public void startAnim(View animView) {
        ValueAnimator animator = ValueAnimator.ofInt(0, 200);
        animator.setDuration(800);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
            @Override
            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                animView.setAlpha(1 - valueAnimator.getAnimatedFraction());
                FrameLayout.LayoutParams params = (FrameLayout.LayoutParams) animView.getLayoutParams();
                params.topMargin = (int) (mY - 80 * valueAnimator.getAnimatedFraction());
                animView.setLayoutParams(params);

                if (valueAnimator.getAnimatedFraction() == 1) {
                    ViewGroup parentViewGroup = (ViewGroup) animView.getParent();
                    if (parentViewGroup != null) {
                        parentViewGroup.removeView(animView);
                    }
                }
            }
        });
        animator.start();
    }

    private void addAnimView(View targetView, View countView, View animview) {
        Activity activityFromView = getActivityFromView(targetView);
        if (activityFromView != null) {
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(FrameLayout.LayoutParams.WRAP_CONTENT, FrameLayout.LayoutParams.WRAP_CONTENT);
            FrameLayout mRootView = (FrameLayout) activityFromView.getWindow().getDecorView().getRootView();
            params.leftMargin = mX + targetView.getMeasuredWidth() + countView.getMeasuredWidth();
            animview.setLayoutParams(params);
            mRootView.addView(animview, params);
        }
    }

    public Activity getActivityFromView(View view) {
        if (null != view) {
            Context context = view.getContext();
            while (context instanceof ContextWrapper) {
                if (context instanceof Activity) {
                    return (Activity) context;
                }
                context = ((ContextWrapper) context).getBaseContext();
            }
        }
        return null;
    }

}