package net.aihelp.ui.cs;

import net.aihelp.data.model.rpa.msg.base.Message;

import androidx.fragment.app.Fragment;

/**
 * 利用接口实现，所有的方法和逻辑都转移给接口
 * 确保每个 View 都全部实现了自己的逻辑，只在最后确认的时候将结果通过接口返回，实现充分解耦
 */
public interface IServiceEventListener {

    void onUserAction(Message message);

    void onUserGoBack();

    void onTicketFinished(int nextStep);

    void onNewConversationStarted();

    void onMiddleHandlerViewVisibilityChanged();

    Fragment getHostFragment();

    void scrollToBottom();

    void scrollBy(int height);

}
