package net.aihelp.ui.cs.bottom;

import android.content.Context;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.step.RPAStep;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.ui.cs.IServiceEventListener;
import net.aihelp.ui.widget.AIHelpFlowLayout;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.Styles;

import androidx.annotation.Nullable;

public class BottomActionPickerView extends BottomBaseView implements AIHelpFlowLayout.OnLabelClickedListener, View.OnClickListener {

    private final AIHelpButton tvSkip;
    private final AIHelpFlowLayout actionList;

    public BottomActionPickerView(Context context) {
        this(context, null);
    }

    public BottomActionPickerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BottomActionPickerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View.inflate(context, ResResolver.getLayoutId("aihelp_bottom_action_picker"), this);

        TextView tvHint = findViewById(ResResolver.getViewId("aihelp_tv_hint"));
        Styles.reRenderTextView(tvHint, ResResolver.getString("aihelp_select_option"));

        tvSkip = findViewById(ResResolver.getViewId("aihelp_tv_skip_action_picker"));
        tvSkip.setOnClickListener(this);

        actionList = findViewById(ResResolver.getViewId("aihelp_fl_actions"));
        actionList.setOnLabelClickedListener(this);

    }

    @Override
    public void onLabelClicked(RPAStep.Action action) {
        if (AppInfoUtil.validateNetwork(getContext()) && mListener != null && action != null) {
            String id = action.getId();
            String content = action.getContent();
            UserMessage userMessage = Message.getUserTextMsg(content);
            userMessage.setRequestParams(content, false, UserMessage.INPUT_FORMAT_BUTTON,
                    id, UserMessage.INPUT_SOURCE_ACTION);
            mListener.onUserAction(userMessage);
        }
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        if (AppInfoUtil.validateNetwork(getContext()) && v.getId() == ResResolver.getViewId("aihelp_tv_skip_action_picker")) {
            if (tvSkip != null && mListener != null) {
                String skip = tvSkip.getText().toString();
                UserMessage userMessage = Message.getUserTextMsg(skip);
                userMessage.setRequestParams(skip, true, UserMessage.INPUT_FORMAT_BUTTON, "", UserMessage.INPUT_SOURCE_SKIP);
                mListener.onUserAction(userMessage);
                tvSkip.setVisibility(GONE);
            }
        }
    }

    @Override
    public void setBottomViewEventListener(Bundle bundle, RPAStep step, IServiceEventListener mListener) {
        super.setBottomViewEventListener(bundle, step, mListener);
        tvSkip.setVisibility(step.isEnableSkip() ? View.VISIBLE : View.GONE);
        tvSkip.setText(step.getSkipHint());
        actionList.update(step.getActionList(), false);
    }

}
