package net.aihelp.ui.cs.bottom;

import android.content.Context;
import android.view.View;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.data.model.rpa.step.RPAStep;
import net.aihelp.ui.cs.util.viewer.EvaluateViewer;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.Styles;

public class BottomEvaluateServiceView extends BottomBaseView implements View.OnClickListener {

    public BottomEvaluateServiceView(Context context) {
        super(context);

        View.inflate(context, ResResolver.getLayoutId("aihelp_bottom_evaluate_service_view"), this);

        // 评价客服相关布局样式
        TextView rateInvite = findViewById(ResResolver.getViewId("aihelp_tv_invite_rate"));
        Styles.reRenderTextView(rateInvite, CustomConfig.InitSetting.csInviteEvaluate);

        AIHelpButton rateButton = findViewById(ResResolver.getViewId(("aihelp_btn_go_rate")));
        rateButton.setText(ResResolver.getString("aihelp_rate_button"));
        rateButton.setOnClickListener(this);

        SoftInputUtil.hideSoftInput(getContext(), rateInvite);

    }

    @Override
    public void onClick(View v) {
        if (AppInfoUtil.validateNetwork(getContext()) && v.getId() == ResResolver.getViewId("aihelp_btn_go_rate")) {
            EvaluateViewer.getInstance().show(getContext(), new EvaluateViewer.OnConfirmEvaluateListener() {
                @Override
                public void onPostEvaluate() {
                    if (mListener != null) {
                        mListener.onTicketFinished(RPAStep.STEP_IGNORE_THIS);
                    }
                }
                @Override
                public void onAfterEvaluate() {
                    if (mListener != null) {
                        mListener.onTicketFinished(RPAStep.STEP_NEW_CONVERSATION);
                    }
                }
            });
        }
    }

}
