package net.aihelp.ui.cs.middle.intent;

import android.content.Context;
import android.util.AttributeSet;

import net.aihelp.utils.Styles;

import androidx.recyclerview.widget.RecyclerView;

public class SmartIntentRecyclerView extends RecyclerView {

    public SmartIntentRecyclerView(Context context) {
        this(context, null);
    }

    public SmartIntentRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SmartIntentRecyclerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        setScrollbarFadingEnabled(false);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {

        float factor = Styles.isLandscape() ? 0.8f : 0.7f;
        // 150dp = StatusBar(10dp) + NavigationBar(44dp) + MiddleHandlerView(20dp) + BottomView(54dp) + LogoView(10dp) + Padding
        int maxHeight = (int) (factor * (Styles.getScreenHeight(getContext()) - Styles.dpToPx(getContext(), 150)));
        maxHeight = Math.min(maxHeight, Styles.dpToPx(getContext(), 40 * 3.5f));

        heightMeasureSpec = MeasureSpec.makeMeasureSpec(maxHeight, MeasureSpec.AT_MOST);
        widthMeasureSpec = MeasureSpec.makeMeasureSpec(Styles.getScreenWidth(getContext()), MeasureSpec.EXACTLY);

        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}
