package net.aihelp.ui.cs.middle.intent;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.HorizontalScrollView;

import net.aihelp.utils.Styles;

import androidx.core.view.ViewCompat;

public class SmartIntentScrollView extends HorizontalScrollView {

    public SmartIntentScrollView(Context context) {
        this(context, null);
    }

    public SmartIntentScrollView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SmartIntentScrollView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void scrollIntentTo(int x) {
        if (Styles.isLayoutRtl(this)) {
            if (x == 0) {
                fullScroll(View.FOCUS_RIGHT);
            } else if (x == Integer.MAX_VALUE) {
                fullScroll(View.FOCUS_LEFT);
            } else {
                super.scrollTo(x, 0);
            }
        } else {
            if (x == 0) {
                fullScroll(View.FOCUS_LEFT);
            } else if (x == Integer.MAX_VALUE) {
                fullScroll(View.FOCUS_RIGHT);
            } else {
                super.scrollTo(x, 0);
            }
        }
    }

    @SuppressLint("ClickableViewAccessibility")
    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        return false;
    }

    @Override
    public void fling(int velocityY) {
        super.fling(velocityY / 40);
    }

}
