package net.aihelp.ui.cs.util;

import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.utils.ListUtil;

import java.util.List;


public class TicketStatusTracker {

    public static int TICKET_ASSIGNED_TO_AGENT = 1;
    public static int TICKET_ASSIGNED_TO_RPA_BOT = 2;
    public static int TICKET_UNASSIGNED_WITH_AGENT = 11;
    public static int TICKET_UNASSIGNED_WITH_BOT = 12;

    public static String currentTicketId;
    public static int ticketPollInterval = 60;

    public static long firstMessageTimeStampInList;

    public static boolean isTicketActive;   // 当前是否有进行中客诉
    public static boolean isTicketFinished; // 当前客诉是否等待评价
    public static boolean isTicketRejected; // 当前客诉是否被回绝

    public static boolean isTicketWaitForAskingResolveStatus;  // 当前客诉是否需要解决未解决调查
    public static boolean isTicketWaitForRating; // 当前客诉是否需要对客服进行评分
    public static boolean isAppRatable; // 是否需要跳转应用商店对 APP 进行评分

    public static boolean hasUnreadMsg; // 是否有未读消息

    public static int ticketAssignType;

    public static boolean isTicketServingByNobody() {
        return ticketAssignType == TICKET_UNASSIGNED_WITH_AGENT;
    }

    public static boolean isTicketServingByAgent() {
        return ticketAssignType == TICKET_ASSIGNED_TO_AGENT || ticketAssignType == TICKET_UNASSIGNED_WITH_AGENT;
    }

    public static boolean isTicketServingByRPA() {
        return ticketAssignType == TICKET_ASSIGNED_TO_RPA_BOT;
    }

    public static boolean isTicketServingByAnswerBot() {
        return ticketAssignType == TICKET_UNASSIGNED_WITH_BOT;
    }

    public static void setFirstMessageTimeStampInList(List<Message> msgList) {
        if (!ListUtil.isListEmpty(msgList)) {
            Message message = msgList.get(0);
            if (message != null) {
                TicketStatusTracker.firstMessageTimeStampInList = message.getTimestamp();
            }
        }
    }

    public static void updateAssignTypeWithActiveStatus(boolean isTicketActive, int ticketAssignType) {
        TicketStatusTracker.isTicketActive = isTicketActive;
        TicketStatusTracker.hasUnreadMsg = false; // 重新登录之后重置未读消息数
        TicketStatusTracker.ticketAssignType = ticketAssignType;
        if (!isTicketActive) {
            TicketStatusTracker.ticketAssignType = TICKET_UNASSIGNED_WITH_BOT;
        }
    }

    public static void resetTicketStatusFlags() {
        hasUnreadMsg = false;
        isTicketActive = false;
        isTicketWaitForAskingResolveStatus = false;
        isTicketWaitForRating = false;
        isTicketRejected = false;
        isTicketFinished = false;
    }

}
