package net.aihelp.ui.cs.util.rpa.helper;

import android.text.TextUtils;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.model.cs.ChatInfoEntity;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class ChatInfoHelper {

    private static final int MESSAGE_FROM_USER = 1;
    private static final int MESSAGE_FROM_AGENT_OR_BOT = 2;
    private static final int CUSTOMER_TYPE_AGENT = 0;
    private static final int CUSTOMER_TYPE_BOT = 1;

    // region - login 历史记录处理
    private static String assigneeInfo;

    private static List<ChatInfoEntity> getListForLoginAndPoll(String jsonString) {
        ArrayList<ChatInfoEntity> chatInfoList = new ArrayList<>();
        Pattern pattern = Pattern.compile("[0-9]*");

        JSONObject loginMsgObject = JsonHelper.getJsonObject(jsonString);

        Iterator<String> keys = loginMsgObject.keys();
        while (keys.hasNext()) {
            String key = keys.next();

            // 提取客诉分配信息
            if ("assigneeinfo".equals(key)) {
                assigneeInfo = loginMsgObject.optString("assigneeinfo");
                continue;
            }

            // 提取时间戳
            if (CustomConfig.CustomerService.isMessageTimestampVisible && "chatTimestamp".equals(key)) {
                prepareTimeStampMessageForLogin(chatInfoList, loginMsgObject.optString("chatTimestamp"));
                continue;
            }

            // 取出所有的消息时间戳，过程中处理好人工客服的昵称
            String[] chatKey = key.split("\\|");
            if (pattern.matcher(chatKey[0]).matches()) {
                ChatInfoEntity entity = new ChatInfoEntity();
                entity.setTimeStamp(Long.parseLong(chatKey[0]));
                if (chatKey.length == 2) {
                    String agentName = chatKey[1];
                    entity.setMsgType("Bot".equals(agentName) ? ChatInfoEntity.TYPE_BOT : ChatInfoEntity.TYPE_AGENT);
                    entity.setAgentName(agentName);
                } else {
                    entity.setMsgType(ChatInfoEntity.TYPE_USER);
                    entity.setAgentName("");
                }
                // historyEntity 里有 type，根据 type 判断是客服还是用户，然后生成消息对象
                entity.setMessage(loginMsgObject.optString(getConversationJSONObjectKey(entity)));
                chatInfoList.add(entity);
            }
        }

        // 依据时间戳对所有的消息进行排序处理
        Collections.sort(chatInfoList);
        return chatInfoList;
    }

    public static void prepareTimeStampMessageForLogin(ArrayList<ChatInfoEntity> chatInfoList, String chatTimeStamp) {
        if (TextUtils.isEmpty(chatTimeStamp)) return;
        String[] timeStampArray = chatTimeStamp.split(",");
        for (String timeStamp : timeStampArray) {
            if (Pattern.compile("[0-9]*").matcher(timeStamp).matches()) {
                ChatInfoEntity entity = new ChatInfoEntity();
                entity.setMsgType(ChatInfoEntity.TYPE_TIMESTAMP);
                entity.setTimeStamp(Long.parseLong(timeStamp) - 1);
                chatInfoList.add(entity);
            }
        }
    }

    public static void prepareNickname(ChatInfoEntity entity) {
        if (!TextUtils.isEmpty(assigneeInfo)) {
            try {
                JSONArray jsonArray = new JSONArray(assigneeInfo);
                if (jsonArray.length() > 0) {
                    for (int i = 0; i < jsonArray.length(); i++) {
                        JSONObject jsonObject = jsonArray.getJSONObject(i);
                        int userId = jsonObject.optInt("userid");
                        String userName = jsonObject.optString("username");
                        if (entity.getUserId() == userId || entity.getAgentName().equals(userName)) {
                            String nickname = JsonHelper.optString(jsonObject, "nickname");
                            entity.setAgentNickname(nickname);
                            break;
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getConversationJSONObjectKey(ChatInfoEntity infoEntity) {
        String key = String.valueOf(infoEntity.getTimeStamp());
        if (!TextUtils.isEmpty(infoEntity.getAgentName())) {
            key = key + "|" + infoEntity.getAgentName();
        }
        return key;
    }
    // endregion

    // region - 下拉刷新获取历史记录
    private static List<ChatInfoEntity> getListForRefresh(String jsonString) {
        List<ChatInfoEntity> chatInfoList = new ArrayList<>();
        JSONArray jsonArray = JsonHelper.getJsonArray(jsonString);
        for (int i = 0; i < jsonArray.length(); i++) {
            JSONObject jsonObject = JsonHelper.getJsonObject(jsonArray, i);

            if (jsonObject.optBoolean("isWithdraw")) {
                continue;
            }

            if (jsonObject.optBoolean("isShowTimeLine")) {
                ChatInfoEntity entity = new ChatInfoEntity();
                entity.setMsgType(ChatInfoEntity.TYPE_TIMESTAMP);
                entity.setTimeStamp(jsonObject.optLong("messageTime", 0) - 1);
                chatInfoList.add(entity);
            }

            ChatInfoEntity entity = new ChatInfoEntity();
            entity.setTimeStamp(jsonObject.optLong("messageTime", 0));
            entity.setAgentNickname(JsonHelper.optString(jsonObject, "customer"));
            entity.setUserId(jsonObject.optInt("customerId", 0));
            entity.setMessage(getMessageString(jsonObject));
            entity.setMsgType(getMessageType(jsonObject));
            chatInfoList.add(entity);
        }
        Collections.sort(chatInfoList);
        return chatInfoList;
    }

    private static String getMessageString(JSONObject jsonObject) {
        JSONObject messageObject = new JSONObject();
        try {
            messageObject.put("content", JsonHelper.optString(jsonObject, "message"));
            messageObject.put("feedback", jsonObject.optInt("feedback"));
        } catch (Exception e) {
            // ignored
        }
        return messageObject.toString();
    }

    private static int getMessageType(JSONObject jsonObject) {
        switch (jsonObject.optInt("messageFrom")) {
            case MESSAGE_FROM_USER:
                return ChatInfoEntity.TYPE_USER;
            case MESSAGE_FROM_AGENT_OR_BOT:
                if (jsonObject.optInt("customerType") == CUSTOMER_TYPE_AGENT) {
                    return ChatInfoEntity.TYPE_AGENT;
                } else {
                    return ChatInfoEntity.TYPE_BOT;
                }
        }
        return ChatInfoEntity.TYPE_TIMESTAMP;
    }
    // endregion

    public static List<ChatInfoEntity> getChatInfoList(String jsonString, int historyType) {
        switch (historyType) {
            case HistoryHelper.HISTORY_TYPE_LOGIN:
            case HistoryHelper.HISTORY_TYPE_POLL:
                return getListForLoginAndPoll(jsonString);
            case HistoryHelper.HISTORY_TYPE_REFRESH:
                return getListForRefresh(jsonString);
            default:
                return new ArrayList<>();
        }
    }

}
